/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.http.CaseInsensitiveKey;
import com.github.tomakehurst.wiremock.http.MultiValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class HttpHeader
extends MultiValue {
    public HttpHeader(String key, String ... values2) {
        super(key, Arrays.asList(values2));
    }

    public HttpHeader(CaseInsensitiveKey key, Collection<String> values2) {
        super(key.value(), List.copyOf(values2));
    }

    public HttpHeader(String key, Collection<String> values2) {
        super(key, List.copyOf(ParameterUtils.getFirstNonNull(values2, Collections.emptyList())));
    }

    public static HttpHeader httpHeader(CaseInsensitiveKey key, String ... values2) {
        return new HttpHeader(key.value(), values2);
    }

    public static HttpHeader httpHeader(String key, String ... values2) {
        return new HttpHeader(key, values2);
    }

    public static HttpHeader absent(String key) {
        return new HttpHeader(key, new String[0]);
    }

    public static HttpHeader empty(String key) {
        return HttpHeader.httpHeader(key, "");
    }

    public CaseInsensitiveKey caseInsensitiveKey() {
        return CaseInsensitiveKey.from(this.key);
    }

    public boolean keyEquals(String candidateKey) {
        return CaseInsensitiveKey.from(candidateKey).equals(this.caseInsensitiveKey());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpHeader that = (HttpHeader)o;
        if (this.key != null ? !this.key.equalsIgnoreCase(that.key) : that.key != null) {
            return false;
        }
        return !(this.values != null ? !this.values.equals(that.values) : that.values != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.toLowerCase().hashCode() : 0;
        result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
        return result;
    }
}

