/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.lang;

public class ExceptionHelp {
    public static String toStringWithCauses(Throwable t2) {
        StringBuilder sb = new StringBuilder();
        sb.append(t2);
        while (t2.getCause() != null) {
            t2 = t2.getCause();
            sb.append("; caused by: ").append(t2);
        }
        return sb.toString();
    }

    public static String toStringWithCausesAndAbbreviatedStack(Throwable t2, Class stopAt) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        while (t2 != null) {
            if (!first) {
                sb.append("; caused by: ");
            }
            sb.append(t2).append(" at ");
            for (StackTraceElement ste : t2.getStackTrace()) {
                if (ste.getClassName().equals(stopAt.getName())) {
                    sb.append("...omitted...");
                    break;
                }
                sb.append(ste).append("; ");
            }
            t2 = t2.getCause();
            first = false;
        }
        return sb.toString();
    }
}

