/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.jose4j.keys.KeyPersuasion;
import org.jose4j.lang.JoseException;
import org.jose4j.zip.CompressionAlgorithm;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class DeflateRFC1951CompressionAlgorithm
implements CompressionAlgorithm {
    private static final Logger log = LoggerFactory.getLogger(DeflateRFC1951CompressionAlgorithm.class);
    public static final String DECOMPRESS_MAX_BYTES_PROPERTY_NAME = "org.jose4j.zip.decompress-max-bytes";
    private int maxDecompressedBytes = 204800;

    public DeflateRFC1951CompressionAlgorithm() {
        String property = System.getProperty(DECOMPRESS_MAX_BYTES_PROPERTY_NAME, "204800");
        try {
            this.maxDecompressedBytes = Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            log.debug("Using the default value of " + this.maxDecompressedBytes + " for the maximum allowed size of decompressed data because the system property " + DECOMPRESS_MAX_BYTES_PROPERTY_NAME + " contains an invalid value: " + e);
        }
        log.debug("");
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] compress(byte[] data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public byte[] decompress(byte[] compressedData) throws JoseException {
        Inflater inflater = new Inflater(true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] byArray;
            InflaterInputStream iis = new InflaterInputStream(new ByteArrayInputStream(compressedData), inflater);
            try {
                int bytesRead;
                byte[] buff = new byte[256];
                while ((bytesRead = iis.read(buff)) != -1) {
                    byteArrayOutputStream.write(buff, 0, bytesRead);
                    if (byteArrayOutputStream.size() <= this.maxDecompressedBytes) continue;
                    throw new JoseException("Maximum allowed size of decompressed data exceeded (which is " + this.maxDecompressedBytes + " bytes but configurable with the " + DECOMPRESS_MAX_BYTES_PROPERTY_NAME + " system property)");
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        iis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new JoseException("Problem decompressing data.", e);
                }
            }
            iis.close();
            return byArray;
        }
        finally {
            inflater.end();
        }
    }

    @Override
    public String getJavaAlgorithm() {
        return null;
    }

    @Override
    public String getAlgorithmIdentifier() {
        return "DEF";
    }

    @Override
    public KeyPersuasion getKeyPersuasion() {
        return KeyPersuasion.NONE;
    }

    @Override
    public String getKeyType() {
        return null;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

