/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import wiremock.com.github.jknack.handlebars.PathCompiler;
import wiremock.com.github.jknack.handlebars.PathExpression;
import wiremock.com.github.jknack.handlebars.ValueResolver;
import wiremock.com.github.jknack.handlebars.context.MapValueResolver;
import wiremock.com.github.jknack.handlebars.internal.lang3.Validate;
import wiremock.com.github.jknack.handlebars.internal.path.ThisPath;

public class Context {
    private static final Object NULL = new Object();
    public static final String PARTIALS = Context.class.getName() + "#partials";
    public static final String INLINE_PARTIALS = "__inline_partials_";
    public static final String INVOCATION_STACK = Context.class.getName() + "#invocationStack";
    public static final String PARAM_SIZE = Context.class.getName() + "#paramSize";
    public static final String CALLEE = Context.class.getName() + "#callee";
    protected Context parent;
    Object model;
    protected Map<String, Object> data;
    protected Context extendedContext;
    protected ValueResolver resolver;

    protected Context(Object model) {
        this.model = model;
        this.extendedContext = null;
        this.parent = null;
    }

    private static Context root(Object model) {
        Context root = new Context(model);
        root.extendedContext = new Context(new HashMap());
        root.data = new HashMap<String, Object>();
        root.data.put(PARTIALS, new HashMap());
        LinkedList partials = new LinkedList();
        partials.push(new HashMap());
        root.data.put(INLINE_PARTIALS, partials);
        root.data.put(INVOCATION_STACK, new LinkedList());
        root.data.put("root", model);
        return root;
    }

    public Context combine(String name, Object model) {
        Map map = (Map)this.extendedContext.model;
        map.put(name, model);
        return this;
    }

    public Context combine(Map<String, ?> model) {
        Map map = (Map)this.extendedContext.model;
        map.putAll(model);
        return this;
    }

    public <T> T data(String name) {
        return (T)this.data.get(name);
    }

    public Context data(String name, Object value) {
        this.data.put(name, value);
        return this;
    }

    public Context data(Map<String, ?> attributes) {
        this.data.putAll(attributes);
        return this;
    }

    public final Object model() {
        return this.model;
    }

    public final Context parent() {
        return this.parent;
    }

    public Set<Map.Entry<String, Object>> propertySet(Object context) {
        if (context == null) {
            return Collections.emptySet();
        }
        if (context instanceof Context) {
            return this.resolver.propertySet(((Context)context).model);
        }
        return this.resolver.propertySet(context);
    }

    public Set<Map.Entry<String, Object>> propertySet() {
        return this.propertySet(this.model);
    }

    public boolean isBlockParams() {
        return this instanceof BlockParam;
    }

    public Object get(List<PathExpression> path) {
        PathExpression head = path.get(0);
        boolean local = head.local();
        Object value = null;
        PathExpressionChain expr = new PathExpressionChain(path);
        Context it = this;
        if (local) {
            value = expr.next(this.resolver, it, it.model);
            if (value == null && !(head instanceof ThisPath)) {
                value = expr.eval(this.resolver, it.extendedContext, it.extendedContext.model);
            }
        } else {
            while (value == null && it != null) {
                value = expr.eval(this.resolver, it, it.model);
                if (value == null && (value = expr.eval(this.resolver, it.extendedContext, it.extendedContext.model)) == null) {
                    value = expr.eval(this.resolver, it, it.data);
                }
                it = it.parent;
            }
        }
        return value == NULL ? null : value;
    }

    public Object get(String key) {
        return this.get(key, true);
    }

    public Object get(String key, boolean parentScopeResolution) {
        return this.get(PathCompiler.compile(key, parentScopeResolution));
    }

    private void setResolver(ValueResolver resolver) {
        this.resolver = resolver;
        this.extendedContext.resolver = resolver;
    }

    public void destroy() {
        this.model = null;
        if (this.parent == null && this.data != null) {
            this.data.clear();
        }
        if (this.extendedContext != null) {
            this.extendedContext.destroy();
        }
        this.parent = null;
        this.resolver = null;
        this.data = null;
    }

    public String toString() {
        return String.valueOf(this.model);
    }

    public static Builder newBuilder(Context parent, Object model) {
        return new Builder(parent, model);
    }

    public static Builder newBuilder(Object model) {
        return new Builder(model);
    }

    public static Context newContext(Context parent, Object model) {
        return Context.newBuilder(parent, model).build();
    }

    public static Context newBlockParamContext(Context parent, List<String> names, List<Object> values2) {
        HashMap<String, Object> hash = new HashMap<String, Object>();
        for (int i = 0; i < Math.min(values2.size(), names.size()); ++i) {
            hash.put(names.get(i), values2.get(i));
        }
        return new BlockParam(parent, hash);
    }

    public static Context newPartialContext(Context ctx, String scope, Map<String, Object> hash) {
        return new PartialCtx(ctx, ctx.get(scope), hash);
    }

    public static Context newContext(Object model) {
        return Context.newBuilder(model).build();
    }

    private Context newChild(Object model) {
        Context child = this.newChildContext(model);
        child.extendedContext = new Context(new HashMap());
        child.setResolver(this.resolver);
        child.parent = this;
        child.data = this.data;
        return child;
    }

    protected Context newChildContext(Object model) {
        return new Context(model);
    }

    public static Context copy(Context context, Object model) {
        Context ctx = Context.newContext(model);
        ctx.data = context.data;
        ctx.resolver = context.resolver;
        return ctx;
    }

    private static class PathExpressionChain
    implements PathExpression.Chain {
        private List<PathExpression> path;
        private int i = 0;

        PathExpressionChain(List<PathExpression> path) {
            this.path = path;
        }

        @Override
        public Object next(ValueResolver resolver, Context context, Object data) {
            if (data != null && this.i < this.path.size()) {
                PathExpression next = this.path.get(this.i++);
                return next.eval(resolver, context, data, this);
            }
            return data;
        }

        @Override
        public List<PathExpression> path() {
            return this.path.subList(this.i, this.path.size());
        }

        public Object eval(ValueResolver resolver, Context context, Object data) {
            this.i = 0;
            Object value = this.next(resolver, context, data);
            if (value == null) {
                return this.i > 1 ? NULL : null;
            }
            return value;
        }
    }

    public static final class Builder {
        private Context context;

        private Builder(Context parent, Object model) {
            this.context = parent.newChild(model);
        }

        private Builder(Object model) {
            this.context = Context.root(model);
            this.context.setResolver(new CompositeValueResolver(ValueResolver.defaultValueResolvers()));
        }

        public Builder combine(String name, Object model) {
            this.context.combine(name, model);
            return this;
        }

        public Builder combine(Map<String, ?> model) {
            this.context.combine(model);
            return this;
        }

        public Builder resolver(ValueResolver ... resolvers) {
            Validate.notEmpty(resolvers, "At least one value-resolver must be present.", new Object[0]);
            boolean mapResolver = Stream.of(resolvers).anyMatch(MapValueResolver.class::isInstance);
            if (!mapResolver) {
                this.context.setResolver(new CompositeValueResolver(Stream.concat(Stream.of(resolvers), Stream.of(MapValueResolver.INSTANCE)).collect(Collectors.toList())));
            } else {
                this.context.setResolver(new CompositeValueResolver(Arrays.asList(resolvers)));
            }
            return this;
        }

        public Builder push(ValueResolver ... resolvers) {
            Validate.notEmpty(resolvers, "At least one value-resolver must be present.", new Object[0]);
            ArrayList<ValueResolver> merged = new ArrayList<ValueResolver>();
            merged.addAll(ValueResolver.defaultValueResolvers());
            Stream.of(resolvers).forEach(merged::add);
            this.context.setResolver(new CompositeValueResolver(merged));
            return this;
        }

        public Context build() {
            return this.context;
        }
    }

    private static class CompositeValueResolver
    implements ValueResolver {
        private List<ValueResolver> resolvers;

        CompositeValueResolver(List<ValueResolver> resolvers) {
            this.resolvers = resolvers;
        }

        @Override
        public Object resolve(Object context, String name) {
            for (int i = 0; i < this.resolvers.size(); ++i) {
                Object value = this.resolvers.get(i).resolve(context, name);
                if (value == UNRESOLVED) continue;
                return value == null ? NULL : value;
            }
            return null;
        }

        @Override
        public Object resolve(Object context) {
            for (int i = 0; i < this.resolvers.size(); ++i) {
                Object value = this.resolvers.get(i).resolve(context);
                if (value == UNRESOLVED) continue;
                return value == null ? NULL : value;
            }
            return null;
        }

        @Override
        public Set<Map.Entry<String, Object>> propertySet(Object context) {
            LinkedHashSet<Map.Entry<String, Object>> propertySet = new LinkedHashSet<Map.Entry<String, Object>>();
            for (ValueResolver resolver : this.resolvers) {
                propertySet.addAll(resolver.propertySet(context));
            }
            return propertySet;
        }
    }

    private static class PartialCtx
    extends Context {
        protected PartialCtx(Context parent, Object model, Map<String, Object> hash) {
            super(model);
            this.extendedContext = new Context(hash);
            this.extendedContext.resolver = parent.resolver;
            this.extendedContext.extendedContext = new Context(Collections.emptyMap());
            this.parent = parent;
            this.data = parent.data;
            this.resolver = parent.resolver;
        }

        @Override
        public Object get(List<PathExpression> path) {
            String key = path.get(0).toString();
            if (key.equals("this")) {
                return super.get(path);
            }
            Object value = this.extendedContext.get(path);
            if (value == null) {
                return super.get(path);
            }
            return value;
        }
    }

    private static class ParentFirst
    extends Context {
        protected ParentFirst(Object model) {
            super(model);
        }

        @Override
        public Object get(List<PathExpression> path) {
            Object value = this.parent.get(path);
            if (value == null) {
                return super.get(path);
            }
            return value;
        }

        @Override
        protected Context newChildContext(Object model) {
            return new ParentFirst(model);
        }
    }

    private static class BlockParam
    extends Context {
        protected BlockParam(Context parent, Map<String, Object> hash) {
            super(hash);
            this.extendedContext = new Context(new HashMap());
            this.extendedContext.resolver = parent.resolver;
            this.parent = parent;
            this.data = parent.data;
            this.resolver = parent.resolver;
        }

        @Override
        public Object get(List<PathExpression> path) {
            String key = path.get(0).toString();
            if (path.size() == 1 && key.equals("this")) {
                return this.parent.model;
            }
            if (key.startsWith(".") && path.size() > 1) {
                return this.parent.get(path.subList(1, path.size()));
            }
            return super.get(path);
        }

        @Override
        protected Context newChildContext(Object model) {
            return new ParentFirst(model);
        }
    }
}

