/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.cache;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import wiremock.com.github.jknack.handlebars.Parser;
import wiremock.com.github.jknack.handlebars.Template;
import wiremock.com.github.jknack.handlebars.cache.TemplateCache;
import wiremock.com.github.jknack.handlebars.internal.lang3.Validate;
import wiremock.com.github.jknack.handlebars.internal.lang3.tuple.Pair;
import wiremock.com.github.jknack.handlebars.io.TemplateSource;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class ConcurrentMapTemplateCache
implements TemplateCache {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<TemplateSource, Pair<TemplateSource, Template>> cache;
    private boolean reload;

    protected ConcurrentMapTemplateCache(ConcurrentMap<TemplateSource, Pair<TemplateSource, Template>> cache) {
        this.cache = Validate.notNull(cache, "The cache is required.", new Object[0]);
    }

    public ConcurrentMapTemplateCache() {
        this(new ConcurrentHashMap<TemplateSource, Pair<TemplateSource, Template>>());
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void evict(TemplateSource source2) {
        this.cache.remove(source2);
    }

    @Override
    public Template get(TemplateSource source2, Parser parser) throws IOException {
        Validate.notNull(source2, "The source is required.", new Object[0]);
        Validate.notNull(parser, "The parser is required.", new Object[0]);
        return this.cacheGet(source2, parser);
    }

    @Override
    public ConcurrentMapTemplateCache setReload(boolean reload) {
        this.reload = reload;
        return this;
    }

    private Template cacheGet(TemplateSource source2, Parser parser) throws IOException {
        Pair<TemplateSource, Template> entry = (Pair<TemplateSource, Template>)this.cache.get(source2);
        if (entry == null) {
            this.logger.debug("Loading: {}", (Object)source2);
            entry = Pair.of(source2, parser.parse(source2));
            this.cache.put(source2, entry);
        } else if (this.reload && source2.lastModified() != ((TemplateSource)entry.getKey()).lastModified()) {
            this.evict(source2);
            this.logger.debug("Reloading: {}", (Object)source2);
            entry = Pair.of(source2, parser.parse(source2));
            this.cache.put(source2, entry);
        } else {
            this.logger.debug("Found in cache: {}", (Object)source2);
        }
        return (Template)entry.getValue();
    }
}

