/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import wiremock.com.github.jknack.handlebars.Context;
import wiremock.com.github.jknack.handlebars.Handlebars;
import wiremock.com.github.jknack.handlebars.HandlebarsError;
import wiremock.com.github.jknack.handlebars.HandlebarsException;
import wiremock.com.github.jknack.handlebars.PathCompiler;
import wiremock.com.github.jknack.handlebars.PathExpression;
import wiremock.com.github.jknack.handlebars.Template;
import wiremock.com.github.jknack.handlebars.internal.HelperResolver;
import wiremock.com.github.jknack.handlebars.internal.Param;
import wiremock.com.github.jknack.handlebars.internal.PartialBlockForwardingTemplate;
import wiremock.com.github.jknack.handlebars.internal.lang3.StringUtils;
import wiremock.com.github.jknack.handlebars.internal.lang3.Validate;
import wiremock.com.github.jknack.handlebars.io.TemplateLoader;
import wiremock.com.github.jknack.handlebars.io.TemplateSource;

class Partial
extends HelperResolver {
    private static final List<List<PathExpression>> OVERRIDE_PROPERTIES = Arrays.asList(PathCompiler.compile("size"), PathCompiler.compile("empty"));
    private Template path;
    private String context;
    private String scontext;
    private String startDelimiter;
    private String endDelimiter;
    private String indent;
    private TemplateLoader loader;
    private Template partial;
    private boolean decorate;

    Partial(Handlebars handlebars, Template path, String context, Map<String, Param> hash) {
        super(handlebars);
        this.path = Validate.notNull(path, "The path is required.", new Object[0]);
        this.context = context;
        this.scontext = context == null ? "this" : context;
        this.hash(hash);
        this.loader = handlebars.getLoader();
    }

    @Override
    public void before(Context context, Writer writer) throws IOException {
        LinkedList partials = (LinkedList)context.data("__inline_partials_");
        partials.addLast(new HashMap((Map)partials.getLast()));
    }

    @Override
    public void after(Context context, Writer writer) throws IOException {
        LinkedList partials = (LinkedList)context.data("__inline_partials_");
        if (partials.size() > 0) {
            partials.removeLast();
        }
    }

    @Override
    public boolean decorate() {
        return this.decorate;
    }

    Partial setDecorate(boolean decorate) {
        this.decorate = decorate;
        return this;
    }

    @Override
    protected void merge(Context context, Writer writer) throws IOException {
        try {
            Template template;
            boolean parentIsNotLastPartialBlock;
            String path = this.path.apply(context);
            LinkedList partials = (LinkedList)context.data("__inline_partials_");
            Map inlineTemplates = (Map)partials.getLast();
            Template callee = (Template)context.data(Context.CALLEE);
            boolean pathIsPartialBlock = "@partial-block".equals(path);
            Template lastPartialBlock = (Template)inlineTemplates.get("@partial-block");
            boolean bl = parentIsNotLastPartialBlock = !this.isCalleeOf(callee, lastPartialBlock);
            if (pathIsPartialBlock && parentIsNotLastPartialBlock) {
                throw new IllegalArgumentException(callee + " does not provide a @partial-block for " + this);
            }
            if (this.partial != null) {
                if (this.handlebars.preEvaluatePartialBlocks()) {
                    this.partial.apply(context);
                }
                inlineTemplates.put("@partial-block", new PartialBlockForwardingTemplate(this, this.partial, (Template)inlineTemplates.get("@partial-block"), callee, this.handlebars));
            }
            if ((template = (Template)inlineTemplates.get(path)) == null) {
                LinkedList invocationStack = (LinkedList)context.data(Context.INVOCATION_STACK);
                try {
                    TemplateSource source2 = this.loader.sourceAt(path);
                    if (Partial.exists(invocationStack, source2.filename())) {
                        String message;
                        String reason;
                        TemplateSource caller = (TemplateSource)invocationStack.removeLast();
                        Collections.reverse(invocationStack);
                        if (invocationStack.isEmpty()) {
                            reason = String.format("infinite loop detected, partial '%s' is calling itself", source2.filename());
                            message = String.format("%s:%s:%s: %s", caller.filename(), this.line, this.column, reason);
                        } else {
                            reason = String.format("infinite loop detected, partial '%s' was previously loaded", source2.filename());
                            message = String.format("%s:%s:%s: %s\n%s", caller.filename(), this.line, this.column, reason, "at " + StringUtils.join(invocationStack, "\nat "));
                        }
                        HandlebarsError error = new HandlebarsError(caller.filename(), this.line, this.column, reason, this.text(), message);
                        throw new HandlebarsException(error);
                    }
                    if (this.indent != null) {
                        source2 = Partial.partial(source2, this.indent);
                    }
                    template = this.handlebars.compile(source2);
                }
                catch (FileNotFoundException fnf) {
                    if (this.partial != null) {
                        template = this.partial;
                    }
                    throw fnf;
                }
            }
            context.data(Context.CALLEE, this);
            Map<String, Object> hash = this.hash(context);
            this.override(context, hash, OVERRIDE_PROPERTIES);
            Context ctx = Context.newPartialContext(context, this.scontext, hash);
            template.apply(ctx, writer);
            context.data(Context.CALLEE, callee);
        }
        catch (IOException ex) {
            String reason = String.format("The partial '%s' at '%s' could not be found", this.loader.resolve(this.path.text()), ex.getMessage());
            String message = String.format("%s:%s:%s: %s", this.filename, this.line, this.column, reason);
            HandlebarsError error = new HandlebarsError(this.filename, this.line, this.column, reason, this.text(), message);
            throw new HandlebarsException(error);
        }
    }

    private void override(Context context, Map<String, Object> hash, List<List<PathExpression>> properties) {
        for (List<PathExpression> path : properties) {
            String key = path.toString();
            if (hash.containsKey(key)) continue;
            hash.put(key, context.get(path));
        }
    }

    private boolean isCalleeOf(Template callee, Template partialBlock) {
        if (callee == null || partialBlock == null) {
            return false;
        }
        if (!callee.filename().equalsIgnoreCase(partialBlock.filename())) {
            return false;
        }
        return Arrays.equals(callee.position(), partialBlock.position());
    }

    private static boolean exists(List<TemplateSource> invocationStack, String filename) {
        for (TemplateSource ts : invocationStack) {
            if (!ts.filename().equals(filename)) continue;
            return true;
        }
        return false;
    }

    private static TemplateSource partial(final TemplateSource source2, final String indent) {
        return new TemplateSource(){

            @Override
            public long lastModified() {
                return source2.lastModified();
            }

            @Override
            public String filename() {
                return source2.filename();
            }

            @Override
            public String content(Charset charset) throws IOException {
                return this.partialInput(source2.content(charset), indent);
            }

            public int hashCode() {
                return source2.hashCode();
            }

            public boolean equals(Object obj) {
                return source2.equals(obj);
            }

            public String toString() {
                return source2.toString();
            }

            private String partialInput(String input, String indent2) {
                StringBuilder buffer = new StringBuilder(input.length() + indent2.length());
                buffer.append(indent2);
                int len = input.length();
                for (int idx = 0; idx < len; ++idx) {
                    char ch = input.charAt(idx);
                    buffer.append(ch);
                    if (ch != '\n' || idx >= len - 1) continue;
                    buffer.append(indent2);
                }
                return buffer.toString();
            }
        };
    }

    @Override
    public String text() {
        String hash;
        String params;
        String path = this.path.text();
        StringBuilder buffer = new StringBuilder(this.startDelimiter).append('>').append(path);
        if (this.context != null) {
            buffer.append(' ').append(this.context);
        }
        if ((params = this.paramsToString(this.params)).length() > 0) {
            buffer.append(" ").append(params);
        }
        if ((hash = this.hashToString()).length() > 0) {
            buffer.append(" ").append(hash);
        }
        buffer.append(this.endDelimiter);
        if (this.partial != null) {
            buffer.append(this.partial.text()).append(this.startDelimiter, 0, this.startDelimiter.length() - 1).append("/").append(path).append(this.endDelimiter);
        }
        return buffer.toString();
    }

    public Partial endDelimiter(String endDelimiter) {
        this.endDelimiter = endDelimiter;
        return this;
    }

    public Partial startDelimiter(String startDelimiter) {
        this.startDelimiter = startDelimiter;
        return this;
    }

    public String startDelimiter() {
        return this.startDelimiter;
    }

    public String endDelimiter() {
        return this.endDelimiter;
    }

    public Partial indent(String indent) {
        this.indent = indent;
        return this;
    }

    public Partial setPartial(Template fn) {
        this.partial = fn;
        return this;
    }
}

