/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.google.common.cache;

import java.util.LinkedHashMap;
import java.util.concurrent.ExecutionException;
import wiremock.com.google.common.annotations.GwtIncompatible;
import wiremock.com.google.common.cache.AbstractCache;
import wiremock.com.google.common.cache.ElementTypesAreNonnullByDefault;
import wiremock.com.google.common.cache.LoadingCache;
import wiremock.com.google.common.collect.ImmutableMap;
import wiremock.com.google.common.collect.Maps;
import wiremock.com.google.common.util.concurrent.UncheckedExecutionException;
import wiremock.com.google.errorprone.annotations.CanIgnoreReturnValue;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class AbstractLoadingCache<K, V>
extends AbstractCache<K, V>
implements LoadingCache<K, V> {
    protected AbstractLoadingCache() {
    }

    @Override
    @CanIgnoreReturnValue
    public V getUnchecked(K key) {
        try {
            return this.get(key);
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException(e.getCause());
        }
    }

    @Override
    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys2) throws ExecutionException {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (K key : keys2) {
            if (result.containsKey(key)) continue;
            result.put(key, this.get(key));
        }
        return ImmutableMap.copyOf(result);
    }

    @Override
    public final V apply(K key) {
        return this.getUnchecked(key);
    }

    @Override
    public void refresh(K key) {
        throw new UnsupportedOperationException();
    }
}

