/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.core5.http.impl.bootstrap;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import wiremock.org.apache.hc.core5.annotation.Internal;
import wiremock.org.apache.hc.core5.concurrent.DefaultThreadFactory;
import wiremock.org.apache.hc.core5.concurrent.FutureCallback;
import wiremock.org.apache.hc.core5.function.Callback;
import wiremock.org.apache.hc.core5.function.Decorator;
import wiremock.org.apache.hc.core5.function.Resolver;
import wiremock.org.apache.hc.core5.http.HttpHost;
import wiremock.org.apache.hc.core5.http.impl.DefaultAddressResolver;
import wiremock.org.apache.hc.core5.http.impl.bootstrap.AbstractConnectionInitiatorBase;
import wiremock.org.apache.hc.core5.io.CloseMode;
import wiremock.org.apache.hc.core5.reactor.ConnectionInitiator;
import wiremock.org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import wiremock.org.apache.hc.core5.reactor.IOEventHandlerFactory;
import wiremock.org.apache.hc.core5.reactor.IOReactorConfig;
import wiremock.org.apache.hc.core5.reactor.IOReactorService;
import wiremock.org.apache.hc.core5.reactor.IOReactorStatus;
import wiremock.org.apache.hc.core5.reactor.IOSession;
import wiremock.org.apache.hc.core5.reactor.IOSessionListener;
import wiremock.org.apache.hc.core5.util.Args;
import wiremock.org.apache.hc.core5.util.TimeValue;
import wiremock.org.apache.hc.core5.util.Timeout;

public class AsyncRequester
extends AbstractConnectionInitiatorBase
implements IOReactorService {
    private final DefaultConnectingIOReactor ioReactor;
    private final Resolver<HttpHost, InetSocketAddress> addressResolver;

    @Internal
    public AsyncRequester(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig ioReactorConfig, Decorator<IOSession> ioSessionDecorator, Callback<Exception> exceptionCallback, IOSessionListener sessionListener, Callback<IOSession> sessionShutdownCallback, Resolver<HttpHost, InetSocketAddress> addressResolver) {
        this.ioReactor = new DefaultConnectingIOReactor(eventHandlerFactory, ioReactorConfig, new DefaultThreadFactory("requester-dispatch", true), ioSessionDecorator, exceptionCallback, sessionListener, sessionShutdownCallback);
        this.addressResolver = addressResolver != null ? addressResolver : DefaultAddressResolver.INSTANCE;
    }

    @Override
    ConnectionInitiator getIOReactor() {
        return this.ioReactor;
    }

    public Future<IOSession> requestSession(HttpHost host, Timeout timeout2, Object attachment, FutureCallback<IOSession> callback) {
        Args.notNull(host, "Host");
        Args.notNull(timeout2, "Timeout");
        return this.connect(host, this.addressResolver.resolve(host), null, timeout2, attachment, callback);
    }

    @Override
    public void start() {
        this.ioReactor.start();
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.ioReactor.getStatus();
    }

    @Override
    public void initiateShutdown() {
        this.ioReactor.initiateShutdown();
    }

    @Override
    public void awaitShutdown(TimeValue waitTime) throws InterruptedException {
        this.ioReactor.awaitShutdown(waitTime);
    }

    @Override
    public void close(CloseMode closeMode) {
        this.ioReactor.close(closeMode);
    }

    @Override
    public void close() throws IOException {
        this.ioReactor.close();
    }
}

