/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import java.io.InputStream;
import wiremock.org.apache.hc.core5.http.ClassicHttpRequest;
import wiremock.org.apache.hc.core5.http.HttpException;
import wiremock.org.apache.hc.core5.http.HttpRequestFactory;
import wiremock.org.apache.hc.core5.http.MessageConstraintException;
import wiremock.org.apache.hc.core5.http.RequestHeaderFieldsTooLargeException;
import wiremock.org.apache.hc.core5.http.config.Http1Config;
import wiremock.org.apache.hc.core5.http.impl.io.AbstractMessageParser;
import wiremock.org.apache.hc.core5.http.impl.io.DefaultClassicHttpRequestFactory;
import wiremock.org.apache.hc.core5.http.io.SessionInputBuffer;
import wiremock.org.apache.hc.core5.http.message.LineParser;
import wiremock.org.apache.hc.core5.http.message.RequestLine;
import wiremock.org.apache.hc.core5.util.CharArrayBuffer;

public class DefaultHttpRequestParser
extends AbstractMessageParser<ClassicHttpRequest> {
    private final HttpRequestFactory<ClassicHttpRequest> requestFactory;

    public DefaultHttpRequestParser(LineParser lineParser, HttpRequestFactory<ClassicHttpRequest> requestFactory, Http1Config http1Config) {
        super(lineParser, http1Config);
        this.requestFactory = requestFactory != null ? requestFactory : DefaultClassicHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParser(Http1Config http1Config) {
        this(null, null, http1Config);
    }

    public DefaultHttpRequestParser() {
        this(Http1Config.DEFAULT);
    }

    @Override
    public ClassicHttpRequest parse(SessionInputBuffer buffer, InputStream inputStream2) throws IOException, HttpException {
        try {
            return (ClassicHttpRequest)super.parse(buffer, inputStream2);
        }
        catch (MessageConstraintException ex) {
            throw new RequestHeaderFieldsTooLargeException(ex.getMessage(), ex);
        }
    }

    @Override
    protected ClassicHttpRequest createMessage(CharArrayBuffer buffer) throws IOException, HttpException {
        RequestLine requestLine = this.getLineParser().parseRequestLine(buffer);
        ClassicHttpRequest request = this.requestFactory.newHttpRequest(requestLine.getMethod(), requestLine.getUri());
        request.setVersion(requestLine.getProtocolVersion());
        return request;
    }
}

