/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.custommonkey.xmlunit.jaxp13;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXParseException;
import wiremock.org.custommonkey.xmlunit.exceptions.XMLUnitRuntimeException;
import wiremock.org.xmlunit.XMLUnitException;
import wiremock.org.xmlunit.validation.JAXPValidator;
import wiremock.org.xmlunit.validation.ValidationProblem;

public class Validator {
    private final ArrayList<Source> sources = new ArrayList();
    private final JAXPValidator validator;

    public Validator() {
        this("http://www.w3.org/2001/XMLSchema", null);
    }

    public Validator(String schemaLanguage) {
        this(schemaLanguage, null);
    }

    public Validator(SchemaFactory factory2) {
        this(null, factory2);
    }

    protected Validator(String schemaLanguage, SchemaFactory factory2) {
        this.validator = new JAXPValidator(schemaLanguage, factory2);
    }

    public void addSchemaSource(Source s2) {
        this.sources.add(s2);
        this.validator.setSchemaSources(this.sources.toArray(new Source[0]));
    }

    public boolean isSchemaValid() {
        return this.validator.validateSchema().isValid();
    }

    public List<SAXParseException> getSchemaErrors() {
        return Validator.problemToExceptionList(this.validator.validateSchema().getProblems());
    }

    public boolean isInstanceValid(Source instance) {
        try {
            return this.validator.validateInstance(instance).isValid();
        }
        catch (XMLUnitException e) {
            throw new XMLUnitRuntimeException(e.getMessage(), e.getCause());
        }
    }

    public List<SAXParseException> getInstanceErrors(Source instance) {
        try {
            return Validator.problemToExceptionList(this.validator.validateInstance(instance).getProblems());
        }
        catch (XMLUnitException e) {
            throw new XMLUnitRuntimeException(e.getMessage(), e.getCause());
        }
    }

    private static List<SAXParseException> problemToExceptionList(Iterable<ValidationProblem> problems) {
        ArrayList<SAXParseException> l = new ArrayList<SAXParseException>();
        for (ValidationProblem p : problems) {
            l.add(new SAXParseException(p.getMessage(), null, null, p.getLine(), p.getColumn()));
        }
        return l;
    }
}

