/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import wiremock.org.xmlunit.builder.DifferenceEngineConfigurer;
import wiremock.org.xmlunit.builder.Input;
import wiremock.org.xmlunit.diff.Comparison;
import wiremock.org.xmlunit.diff.ComparisonController;
import wiremock.org.xmlunit.diff.ComparisonControllers;
import wiremock.org.xmlunit.diff.ComparisonFormatter;
import wiremock.org.xmlunit.diff.ComparisonListener;
import wiremock.org.xmlunit.diff.ComparisonResult;
import wiremock.org.xmlunit.diff.DOMDifferenceEngine;
import wiremock.org.xmlunit.diff.Diff;
import wiremock.org.xmlunit.diff.Difference;
import wiremock.org.xmlunit.diff.DifferenceEvaluator;
import wiremock.org.xmlunit.diff.DifferenceEvaluators;
import wiremock.org.xmlunit.diff.NodeMatcher;
import wiremock.org.xmlunit.input.CommentLessSource;
import wiremock.org.xmlunit.input.ElementContentWhitespaceStrippedSource;
import wiremock.org.xmlunit.input.WhitespaceNormalizedSource;
import wiremock.org.xmlunit.input.WhitespaceStrippedSource;
import wiremock.org.xmlunit.util.Predicate;

public class DiffBuilder
implements DifferenceEngineConfigurer<DiffBuilder> {
    private static final ComparisonResult[] CHECK_FOR_SIMILAR = new ComparisonResult[]{ComparisonResult.DIFFERENT};
    private static final ComparisonResult[] CHECK_FOR_IDENTICAL = new ComparisonResult[]{ComparisonResult.SIMILAR, ComparisonResult.DIFFERENT};
    private final Source controlSource;
    private Source testSource;
    private NodeMatcher nodeMatcher;
    private ComparisonController comparisonController = ComparisonControllers.Default;
    private DifferenceEvaluator differenceEvaluator = DifferenceEvaluators.Default;
    private List<ComparisonListener> comparisonListeners = new ArrayList<ComparisonListener>();
    private List<ComparisonListener> differenceListeners = new ArrayList<ComparisonListener>();
    private ComparisonResult[] comparisonResultsToCheck = CHECK_FOR_IDENTICAL;
    private Map<String, String> namespaceContext;
    private Predicate<Attr> attributeFilter;
    private Predicate<Node> nodeFilter;
    private ComparisonFormatter formatter;
    private boolean ignoreWhitespace;
    private boolean normalizeWhitespace;
    private boolean ignoreECW;
    private boolean ignoreComments;
    private String ignoreCommentVersion = null;
    private DocumentBuilderFactory documentBuilderFactory;

    private DiffBuilder(Source controlSource) {
        this.controlSource = controlSource;
    }

    public static DiffBuilder compare(Object control) {
        Source controlSource = DiffBuilder.getSource(control);
        return new DiffBuilder(controlSource);
    }

    public DiffBuilder withTest(Object test) {
        this.testSource = DiffBuilder.getSource(test);
        return this;
    }

    private static Source getSource(Object object) {
        return Input.from(object).build();
    }

    public DiffBuilder ignoreWhitespace() {
        this.ignoreWhitespace = true;
        return this;
    }

    public DiffBuilder normalizeWhitespace() {
        this.normalizeWhitespace = true;
        return this;
    }

    public DiffBuilder ignoreElementContentWhitespace() {
        this.ignoreECW = true;
        return this;
    }

    public DiffBuilder ignoreComments() {
        return this.ignoreCommentsUsingXSLTVersion(null);
    }

    public DiffBuilder ignoreCommentsUsingXSLTVersion(String xsltVersion) {
        this.ignoreComments = true;
        this.ignoreCommentVersion = xsltVersion;
        return this;
    }

    @Override
    public DiffBuilder withNodeMatcher(NodeMatcher nodeMatcher) {
        this.nodeMatcher = nodeMatcher;
        return this;
    }

    @Override
    public DiffBuilder withDifferenceEvaluator(DifferenceEvaluator differenceEvaluator) {
        this.differenceEvaluator = differenceEvaluator;
        return this;
    }

    @Override
    public DiffBuilder withComparisonController(ComparisonController comparisonController) {
        this.comparisonController = comparisonController;
        return this;
    }

    @Override
    public DiffBuilder withComparisonListeners(ComparisonListener ... comparisonListeners) {
        this.comparisonListeners.addAll(Arrays.asList(comparisonListeners));
        return this;
    }

    @Override
    public DiffBuilder withDifferenceListeners(ComparisonListener ... comparisonListeners) {
        this.differenceListeners.addAll(Arrays.asList(comparisonListeners));
        return this;
    }

    public DiffBuilder checkForSimilar() {
        this.comparisonResultsToCheck = CHECK_FOR_SIMILAR;
        return this;
    }

    public DiffBuilder checkForIdentical() {
        this.comparisonResultsToCheck = CHECK_FOR_IDENTICAL;
        return this;
    }

    @Override
    public DiffBuilder withNamespaceContext(Map<String, String> prefix2Uri) {
        this.namespaceContext = prefix2Uri;
        return this;
    }

    @Override
    public DiffBuilder withAttributeFilter(Predicate<Attr> attributeFilter) {
        this.attributeFilter = attributeFilter;
        return this;
    }

    @Override
    public DiffBuilder withNodeFilter(Predicate<Node> nodeFilter) {
        this.nodeFilter = nodeFilter;
        return this;
    }

    @Override
    public DiffBuilder withComparisonFormatter(ComparisonFormatter formatter) {
        this.formatter = formatter;
        return this;
    }

    public DiffBuilder withDocumentBuilderFactory(DocumentBuilderFactory f) {
        this.documentBuilderFactory = f;
        return this;
    }

    public Diff build() {
        DOMDifferenceEngine d = this.documentBuilderFactory != null ? new DOMDifferenceEngine(this.documentBuilderFactory) : new DOMDifferenceEngine();
        CollectResultsListener collectResultsListener = new CollectResultsListener(this.comparisonResultsToCheck);
        d.addDifferenceListener(collectResultsListener);
        if (this.nodeMatcher != null) {
            d.setNodeMatcher(this.nodeMatcher);
        }
        d.setDifferenceEvaluator(this.differenceEvaluator);
        d.setComparisonController(this.comparisonController);
        for (ComparisonListener comparisonListener : this.comparisonListeners) {
            d.addComparisonListener(comparisonListener);
        }
        for (ComparisonListener comparisonListener : this.differenceListeners) {
            d.addDifferenceListener(comparisonListener);
        }
        if (this.namespaceContext != null) {
            d.setNamespaceContext(this.namespaceContext);
        }
        if (this.attributeFilter != null) {
            d.setAttributeFilter(this.attributeFilter);
        }
        if (this.nodeFilter != null) {
            d.setNodeFilter(this.nodeFilter);
        }
        d.compare(this.wrap(this.controlSource), this.wrap(this.testSource));
        return this.formatter == null ? new Diff(this.controlSource, this.testSource, collectResultsListener.getDifferences()) : new Diff(this.controlSource, this.testSource, this.formatter, collectResultsListener.getDifferences());
    }

    private Source wrap(Source source2) {
        Source newSource2 = source2;
        if (this.ignoreWhitespace) {
            Source source3 = newSource2 = this.documentBuilderFactory != null ? new WhitespaceStrippedSource(newSource2, this.documentBuilderFactory) : new WhitespaceStrippedSource(newSource2);
        }
        if (this.normalizeWhitespace) {
            Source source4 = newSource2 = this.documentBuilderFactory != null ? new WhitespaceNormalizedSource(newSource2, this.documentBuilderFactory) : new WhitespaceNormalizedSource(newSource2);
        }
        if (this.ignoreComments) {
            Source source5 = newSource2 = this.ignoreCommentVersion == null ? new CommentLessSource(newSource2) : new CommentLessSource(newSource2, this.ignoreCommentVersion);
        }
        if (this.ignoreECW) {
            newSource2 = this.documentBuilderFactory != null ? new ElementContentWhitespaceStrippedSource(newSource2, this.documentBuilderFactory) : new ElementContentWhitespaceStrippedSource(newSource2);
        }
        return newSource2;
    }

    private static final class CollectResultsListener
    implements ComparisonListener {
        private final List<Difference> results = new ArrayList<Difference>();
        private final EnumSet<ComparisonResult> comparisonResultsToCheck;

        public CollectResultsListener(ComparisonResult ... comparisonResultsToCheck) {
            this.comparisonResultsToCheck = EnumSet.copyOf(Arrays.asList(comparisonResultsToCheck));
        }

        @Override
        public void comparisonPerformed(Comparison comparison, ComparisonResult outcome) {
            if (this.comparisonResultsToCheck.contains((Object)outcome)) {
                this.results.add(new Difference(comparison, outcome));
            }
        }

        public List<Difference> getDifferences() {
            return Collections.unmodifiableList(this.results);
        }
    }
}

