/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import wiremock.org.xmlunit.ConfigurationException;

public class TransformerFactoryConfigurer {
    private final Map<String, Object> attributes;
    private final Map<String, Object> safeAttributes;
    private final Map<String, Boolean> features;
    private final Map<String, Boolean> safeFeatures;
    public static final TransformerFactoryConfigurer Default = TransformerFactoryConfigurer.builder().withDTDLoadingDisabled().withExtensionFunctionsDisabled().build();
    public static final TransformerFactoryConfigurer SecureProcessing = TransformerFactoryConfigurer.builder().withSecureProcessingEnabled().build();
    public static final TransformerFactoryConfigurer NoExternalAccess = TransformerFactoryConfigurer.builder().withDTDLoadingDisabled().withExternalStylesheetLoadingDisabled().withExtensionFunctionsDisabled().build();
    public static final TransformerFactoryConfigurer NoDtdButExtensionFunctions = TransformerFactoryConfigurer.builder().withDTDLoadingDisabled().build();
    public static final TransformerFactoryConfigurer NoExternalAccessButExtensionFunctions = TransformerFactoryConfigurer.builder().withDTDLoadingDisabled().withExternalStylesheetLoadingDisabled().build();

    private TransformerFactoryConfigurer(Map<String, Object> attributes, Map<String, Object> safeAttributes, Map<String, Boolean> features, Map<String, Boolean> safeFeatures) {
        this.attributes = attributes;
        this.safeAttributes = safeAttributes;
        this.features = features;
        this.safeFeatures = safeFeatures;
    }

    public TransformerFactory configure(TransformerFactory factory2) {
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            try {
                factory2.setAttribute(entry.getKey(), entry.getValue());
            }
            catch (IllegalArgumentException ex) {
                throw new ConfigurationException("Error setting attribute " + entry.getKey(), ex);
            }
        }
        for (Map.Entry<String, Object> entry : this.safeAttributes.entrySet()) {
            try {
                factory2.setAttribute(entry.getKey(), entry.getValue());
            }
            catch (IllegalArgumentException ex) {}
        }
        for (Map.Entry<String, Object> entry : this.features.entrySet()) {
            try {
                factory2.setFeature(entry.getKey(), (Boolean)entry.getValue());
            }
            catch (TransformerConfigurationException ex) {
                throw new ConfigurationException("Error setting feature " + entry.getKey(), ex);
            }
        }
        for (Map.Entry<String, Object> entry : this.safeFeatures.entrySet()) {
            try {
                factory2.setFeature(entry.getKey(), (Boolean)entry.getValue());
            }
            catch (TransformerConfigurationException transformerConfigurationException) {}
        }
        return factory2;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, Object> attributes = new HashMap<String, Object>();
        private final Map<String, Object> safeAttributes = new HashMap<String, Object>();
        private final Map<String, Boolean> features = new HashMap<String, Boolean>();
        private final Map<String, Boolean> safeFeatures = new HashMap<String, Boolean>();

        public TransformerFactoryConfigurer build() {
            return new TransformerFactoryConfigurer(Collections.unmodifiableMap(this.attributes), Collections.unmodifiableMap(this.safeAttributes), Collections.unmodifiableMap(this.features), Collections.unmodifiableMap(this.safeFeatures));
        }

        public Builder withAttribute(String key, Object value) {
            this.attributes.put(key, value);
            return this;
        }

        public Builder withSafeAttribute(String key, Object value) {
            this.safeAttributes.put(key, value);
            return this;
        }

        public Builder withFeature(String key, boolean value) {
            this.features.put(key, value);
            return this;
        }

        public Builder withSafeFeature(String key, boolean value) {
            this.safeFeatures.put(key, value);
            return this;
        }

        public Builder withDTDLoadingDisabled() {
            return this.withSafeAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        }

        public Builder withExternalStylesheetLoadingDisabled() {
            return this.withSafeAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }

        public Builder withExtensionFunctionsDisabled() {
            return this.withSafeAttribute("jdk.xml.enableExtensionFunctions", "false");
        }

        public Builder withSecureProcessingEnabled() {
            return this.withFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
    }
}

