/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.util;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import wiremock.org.xmlunit.ConfigurationException;

public class XPathFactoryConfigurer {
    private final Map<String, String> propertys;
    private final Map<String, String> safePropertys;
    private final Map<String, Boolean> features;
    private final Map<String, Boolean> safeFeatures;
    public static final XPathFactoryConfigurer Default = XPathFactoryConfigurer.builder().withExtensionFunctionsDisabled().build();
    public static final XPathFactoryConfigurer SecureProcessing = XPathFactoryConfigurer.builder().withSecureProcessingEnabled().build();
    private static final Method setPropertyMethod;

    private XPathFactoryConfigurer(Map<String, String> propertys, Map<String, String> safePropertys, Map<String, Boolean> features, Map<String, Boolean> safeFeatures) {
        this.propertys = propertys;
        this.safePropertys = safePropertys;
        this.features = features;
        this.safeFeatures = safeFeatures;
    }

    public XPathFactory configure(XPathFactory factory2) {
        for (Map.Entry<String, String> entry : this.propertys.entrySet()) {
            try {
                XPathFactoryConfigurer.setProperty(factory2, entry.getKey(), entry.getValue());
            }
            catch (Exception ex) {
                throw new ConfigurationException("Error setting property " + entry.getKey(), ex);
            }
        }
        for (Map.Entry<String, String> entry : this.safePropertys.entrySet()) {
            try {
                XPathFactoryConfigurer.setProperty(factory2, entry.getKey(), entry.getValue());
            }
            catch (Exception ex) {}
        }
        for (Map.Entry<String, Object> entry : this.features.entrySet()) {
            try {
                factory2.setFeature(entry.getKey(), (Boolean)entry.getValue());
            }
            catch (XPathFactoryConfigurationException ex) {
                throw new ConfigurationException("Error setting feature " + entry.getKey(), ex);
            }
        }
        for (Map.Entry<String, Object> entry : this.safeFeatures.entrySet()) {
            try {
                factory2.setFeature(entry.getKey(), (Boolean)entry.getValue());
            }
            catch (XPathFactoryConfigurationException xPathFactoryConfigurationException) {}
        }
        return factory2;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void setProperty(XPathFactory fac, String name, String value) throws Exception {
        if (setPropertyMethod != null) {
            setPropertyMethod.invoke((Object)fac, name, value);
        }
    }

    static {
        Method m4 = null;
        try {
            m4 = XPathFactory.class.getMethod("setProperty", String.class, String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        setPropertyMethod = m4;
    }

    public static class Builder {
        private final Map<String, String> propertys = new HashMap<String, String>();
        private final Map<String, String> safePropertys = new HashMap<String, String>();
        private final Map<String, Boolean> features = new HashMap<String, Boolean>();
        private final Map<String, Boolean> safeFeatures = new HashMap<String, Boolean>();

        public XPathFactoryConfigurer build() {
            return new XPathFactoryConfigurer(Collections.unmodifiableMap(this.propertys), Collections.unmodifiableMap(this.safePropertys), Collections.unmodifiableMap(this.features), Collections.unmodifiableMap(this.safeFeatures));
        }

        public Builder withProperty(String key, String value) {
            this.propertys.put(key, value);
            return this;
        }

        public Builder withSafeProperty(String key, String value) {
            this.safePropertys.put(key, value);
            return this;
        }

        public Builder withFeature(String key, boolean value) {
            this.features.put(key, value);
            return this;
        }

        public Builder withSafeFeature(String key, boolean value) {
            this.safeFeatures.put(key, value);
            return this;
        }

        public Builder withExtensionFunctionsDisabled() {
            return this.withSafeProperty("jdk.xml.enableExtensionFunctions", "false");
        }

        public Builder withSecureProcessingEnabled() {
            return this.withFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
    }
}

