/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extension.jwt;

import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import java.io.IOException;
import java.security.Key;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;
import org.wiremock.extension.jwt.JwtSigningKeySettings;

public class JwksHandlebarsHelper
extends HandlebarsHelper<Object> {
    private final JwtSigningKeySettings jwtSigningKeySettings;

    public JwksHandlebarsHelper(JwtSigningKeySettings jwtSigningKeySettings) {
        this.jwtSigningKeySettings = jwtSigningKeySettings;
    }

    public Object apply(Object context, Options options) throws IOException {
        try {
            JsonWebKey jsonWebKey = JsonWebKey.Factory.newJwk((Key)this.jwtSigningKeySettings.getKeyPair().publicKey);
            jsonWebKey.setAlgorithm("RS256");
            jsonWebKey.setUse("sig");
            jsonWebKey.setKeyId(this.jwtSigningKeySettings.getRs256PublicKeyId());
            JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(new JsonWebKey[]{jsonWebKey});
            return jsonWebKeySet.toJson();
        }
        catch (JoseException e) {
            throw new IOException(e);
        }
    }
}

