/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extension.jwt;

import com.github.jknack.handlebars.Helper;
import com.github.tomakehurst.wiremock.extension.TemplateHelperProviderExtension;
import java.util.Map;
import org.wiremock.extension.jwt.ClaimListHandlebarsHelper;
import org.wiremock.extension.jwt.JwksHandlebarsHelper;
import org.wiremock.extension.jwt.JwtHandlebarsHelper;
import org.wiremock.extension.jwt.JwtSigningKeySettings;

public class JwtHelpersExtension
implements TemplateHelperProviderExtension {
    private final JwtSigningKeySettings jwtSigningKeySettings;

    public JwtHelpersExtension(JwtSigningKeySettings jwtSigningKeySettings) {
        this.jwtSigningKeySettings = jwtSigningKeySettings;
    }

    public Map<String, Helper<?>> provideTemplateHelpers() {
        JwtHandlebarsHelper jwtHandlebarsHelper = new JwtHandlebarsHelper(this.jwtSigningKeySettings);
        JwksHandlebarsHelper jwksHandlebarsHelper = new JwksHandlebarsHelper(this.jwtSigningKeySettings);
        return Map.of("jwt", jwtHandlebarsHelper, "claims", new ClaimListHandlebarsHelper(), "jwks", jwksHandlebarsHelper);
    }

    public String getName() {
        return "jwt-template-helpers";
    }
}

