/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extension.jwt;

import com.github.tomakehurst.wiremock.extension.MappingsLoaderExtension;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import org.wiremock.extension.jwt.JwtSigningKeySettings;

public class JwtInitialiser
implements MappingsLoaderExtension {
    private final JwtSigningKeySettings jwtSigningKeySettings;
    private boolean initialised = false;

    public JwtInitialiser(JwtSigningKeySettings jwtSigningKeySettings) {
        this.jwtSigningKeySettings = jwtSigningKeySettings;
    }

    public void loadMappingsInto(StubMappings stubMappings) {
        this.initialise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialise() {
        if (!this.initialised) {
            JwtInitialiser jwtInitialiser = this;
            synchronized (jwtInitialiser) {
                if (!this.initialised) {
                    this.jwtSigningKeySettings.initialise();
                    this.initialised = true;
                }
            }
        }
    }

    public String getName() {
        return "jwt-initialiser";
    }
}

