/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extension.jwt;

import com.auth0.jwt.algorithms.Algorithm;
import com.github.tomakehurst.wiremock.common.Metadata;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.extension.GlobalSettingsListener;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.google.common.collect.ImmutableMap;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.wiremock.extension.jwt.PemEncodedKeyPair;
import org.wiremock.extension.jwt.SecretValue;
import org.wiremock.extension.jwt.SettingsUtils;

public class JwtSigningKeySettings
implements GlobalSettingsListener {
    public static final String HS_256_SECRET = "hs256Secret";
    public static final String RS_256_PUBLIC_KEY_ID = "rs256PublicKeyId";
    public static final String RS_256_PUBLIC_KEY = "rs256PublicKey";
    public static final String RS_256_PRIVATE_KEY = "rs256PrivateKey";
    private final Admin wireMockAdmin;
    private PemEncodedKeyPair keyPair;
    private Algorithm hs256Algorithm;
    private Algorithm rs256Algorithm;
    private String rs256PublicKeyId;

    public JwtSigningKeySettings(Admin wireMockAdmin) {
        this.wireMockAdmin = wireMockAdmin;
    }

    public void afterGlobalSettingsUpdated(GlobalSettings oldSettings, GlobalSettings newSettings) {
        Parameters extendedSettings = newSettings.getExtended();
        if (extendedSettings != null && extendedSettings.containsKey((Object)"jwt")) {
            Metadata jwtSettings = extendedSettings.getMetadata("jwt");
            SecretValue hs256Secret = SecretValue.fromString(jwtSettings.getString(HS_256_SECRET));
            String rs256PublicKey = jwtSettings.getString(RS_256_PUBLIC_KEY);
            String rs256PrivateKey = jwtSettings.getString(RS_256_PRIVATE_KEY);
            this.keyPair = PemEncodedKeyPair.parse(rs256PublicKey, rs256PrivateKey);
            this.rs256PublicKeyId = jwtSettings.getString(RS_256_PUBLIC_KEY_ID);
            this.rs256Algorithm = Algorithm.RSA256((RSAPublicKey)this.keyPair.publicKey, (RSAPrivateKey)this.keyPair.privateKey);
            this.hs256Algorithm = Algorithm.HMAC256((byte[])hs256Secret.value());
        }
    }

    public void initialise() {
        GlobalSettings existingSettings = this.wireMockAdmin.getGlobalSettings().getSettings();
        Parameters extendedSettings = existingSettings.getExtended();
        if (extendedSettings == null || !extendedSettings.containsKey((Object)"jwt")) {
            String publicKeyId = RandomStringUtils.randomAlphanumeric((int)30);
            PemEncodedKeyPair keyPair = PemEncodedKeyPair.generate();
            String hs256Secret = RandomStringUtils.randomAlphanumeric((int)36);
            Parameters jwt = Parameters.from((Map)ImmutableMap.of((Object)HS_256_SECRET, (Object)hs256Secret, (Object)RS_256_PUBLIC_KEY_ID, (Object)publicKeyId, (Object)RS_256_PUBLIC_KEY, (Object)keyPair.publicKeyPem(), (Object)RS_256_PRIVATE_KEY, (Object)keyPair.privateKeyPem()));
            GlobalSettings newSettings = GlobalSettings.builder().fixedDelay(existingSettings.getFixedDelay()).delayDistribution(existingSettings.getDelayDistribution()).extended(SettingsUtils.merge(existingSettings.getExtended(), Parameters.one((String)"jwt", (Object)jwt))).build();
            this.wireMockAdmin.updateGlobalSettings(newSettings);
        }
    }

    public PemEncodedKeyPair getKeyPair() {
        return this.keyPair;
    }

    public Algorithm getHs256Algorithm() {
        return this.hs256Algorithm;
    }

    public Algorithm getRs256Algorithm() {
        return this.rs256Algorithm;
    }

    public String getRs256PublicKeyId() {
        return this.rs256PublicKeyId;
    }

    public String getName() {
        return "jwt-signing-key-settings-listener";
    }

    public void beforeGlobalSettingsUpdated(GlobalSettings oldSettings, GlobalSettings newSettings) {
    }
}

