/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.client.BasicCredentials;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.common.url.PathParams;
import com.github.tomakehurst.wiremock.common.url.PathTemplate;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.CustomMatcherDefinition;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.MultipartValuePattern;
import com.github.tomakehurst.wiremock.matching.NamedValueMatcher;
import com.github.tomakehurst.wiremock.matching.RequestMatcher;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPathPattern;
import com.github.tomakehurst.wiremock.matching.UrlPathTemplatePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;
import com.github.tomakehurst.wiremock.matching.WeightedMatchResult;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class RequestPattern
implements NamedValueMatcher<Request> {
    private final String scheme;
    private final StringValuePattern host;
    private final Integer port;
    private final UrlPattern url;
    private final RequestMethod method;
    private final Map<String, MultiValuePattern> headers;
    private final Map<String, StringValuePattern> pathParams;
    private final Map<String, MultiValuePattern> queryParams;
    private final Map<String, MultiValuePattern> formParams;
    private final Map<String, StringValuePattern> cookies;
    private final BasicCredentials basicAuthCredentials;
    private final List<ContentPattern<?>> bodyPatterns;
    private final List<MultipartValuePattern> multipartPatterns;
    private final CustomMatcherDefinition customMatcherDefinition;
    private final ValueMatcher<Request> matcher;
    private final boolean hasInlineCustomMatcher;
    public static final RequestPattern ANYTHING = new RequestPattern(null, null, null, WireMock.anyUrl(), RequestMethod.ANY, null, null, null, null, null, null, null, null, null, null);

    public RequestPattern(String scheme, StringValuePattern host, Integer port, UrlPattern url, RequestMethod method, Map<String, MultiValuePattern> headers, Map<String, StringValuePattern> pathParams, Map<String, MultiValuePattern> queryParams, Map<String, MultiValuePattern> formParams, Map<String, StringValuePattern> cookies, BasicCredentials basicAuthCredentials, List<ContentPattern<?>> bodyPatterns, CustomMatcherDefinition customMatcherDefinition, final ValueMatcher<Request> customMatcher, List<MultipartValuePattern> multiPattern) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.url = ParameterUtils.getFirstNonNull(url, UrlPattern.ANY);
        this.method = ParameterUtils.getFirstNonNull(method, RequestMethod.ANY);
        this.headers = headers;
        this.pathParams = pathParams;
        this.formParams = formParams;
        this.queryParams = queryParams;
        this.cookies = cookies;
        this.basicAuthCredentials = basicAuthCredentials;
        this.bodyPatterns = bodyPatterns;
        this.customMatcherDefinition = customMatcherDefinition;
        this.multipartPatterns = multiPattern;
        this.hasInlineCustomMatcher = customMatcher != null;
        this.matcher = new RequestMatcher(){

            @Override
            public MatchResult match(Request request) {
                ArrayList<WeightedMatchResult> matchResults = new ArrayList<WeightedMatchResult>(Arrays.asList(WeightedMatchResult.weight(RequestPattern.this.schemeMatches(request), 3.0), WeightedMatchResult.weight(RequestPattern.this.hostMatches(request), 10.0), WeightedMatchResult.weight(RequestPattern.this.portMatches(request), 10.0), WeightedMatchResult.weight(RequestPattern.this.url.match(request.getUrl()), 10.0), WeightedMatchResult.weight(RequestPattern.this.method.match(request.getMethod()), 3.0), WeightedMatchResult.weight(RequestPattern.this.allPathParamsMatch(request)), WeightedMatchResult.weight(RequestPattern.this.allHeadersMatchResult(request)), WeightedMatchResult.weight(RequestPattern.this.allQueryParamsMatch(request)), WeightedMatchResult.weight(RequestPattern.this.allFormParamsMatch(request)), WeightedMatchResult.weight(RequestPattern.this.allCookiesMatch(request)), WeightedMatchResult.weight(RequestPattern.this.allBodyPatternsMatch(request)), WeightedMatchResult.weight(RequestPattern.this.allMultipartPatternsMatch(request))));
                if (RequestPattern.this.hasInlineCustomMatcher) {
                    matchResults.add(WeightedMatchResult.weight(customMatcher.match(request)));
                }
                return MatchResult.aggregateWeighted(matchResults);
            }

            @Override
            public String getName() {
                return "request-matcher";
            }
        };
    }

    @JsonCreator
    public RequestPattern(@JsonProperty(value="scheme") String scheme, @JsonProperty(value="host") StringValuePattern host, @JsonProperty(value="port") Integer port, @JsonProperty(value="url") String url, @JsonProperty(value="urlPattern") String urlPattern, @JsonProperty(value="urlPath") String urlPath, @JsonProperty(value="urlPathPattern") String urlPathPattern, @JsonProperty(value="urlPathTemplate") String urlPathTemplate, @JsonProperty(value="method") RequestMethod method, @JsonProperty(value="headers") Map<String, MultiValuePattern> headers, @JsonProperty(value="pathParameters") Map<String, StringValuePattern> pathParams, @JsonProperty(value="queryParameters") Map<String, MultiValuePattern> queryParams, @JsonProperty(value="formParameters") Map<String, MultiValuePattern> formParams, @JsonProperty(value="cookies") Map<String, StringValuePattern> cookies, @JsonProperty(value="basicAuth") BasicCredentials basicAuthCredentials, @JsonProperty(value="bodyPatterns") List<ContentPattern<?>> bodyPatterns, @JsonProperty(value="customMatcher") CustomMatcherDefinition customMatcherDefinition, @JsonProperty(value="multipartPatterns") List<MultipartValuePattern> multiPattern) {
        this(scheme, host, port, UrlPattern.fromOneOf(url, urlPattern, urlPath, urlPathPattern, urlPathTemplate), method, headers, pathParams, queryParams, formParams, cookies, basicAuthCredentials, bodyPatterns, customMatcherDefinition, null, multiPattern);
    }

    public RequestPattern(ValueMatcher<Request> customMatcher) {
        this(null, null, null, UrlPattern.ANY, RequestMethod.ANY, null, null, null, null, null, null, null, null, customMatcher, null);
    }

    public RequestPattern(CustomMatcherDefinition customMatcherDefinition) {
        this(null, null, null, UrlPattern.ANY, RequestMethod.ANY, null, null, null, null, null, null, null, customMatcherDefinition, null, null);
    }

    @Override
    public MatchResult match(Request request) {
        return this.match(request, Collections.emptyMap());
    }

    public static RequestPattern everything() {
        return RequestPatternBuilder.newRequestPattern(RequestMethod.ANY, WireMock.anyUrl()).build();
    }

    public MatchResult match(Request request, Map<String, RequestMatcherExtension> customMatchers) {
        if (this.customMatcherDefinition != null) {
            RequestMatcherExtension requestMatcher = ParameterUtils.getFirstNonNull(customMatchers.get(this.customMatcherDefinition.getName()), RequestMatcherExtension.NEVER);
            MatchResult standardMatchResult = this.matcher.match(request);
            MatchResult customMatchResult = requestMatcher.match(request, this.customMatcherDefinition.getParameters());
            return MatchResult.aggregate(standardMatchResult, customMatchResult);
        }
        return this.matcher.match(request);
    }

    private MatchResult allCookiesMatch(Request request) {
        if (this.cookies != null && !this.cookies.isEmpty()) {
            return MatchResult.aggregate(this.cookies.entrySet().stream().map(entry -> {
                StringValuePattern cookiePattern = (StringValuePattern)entry.getValue();
                Cookie cookie = request.getCookies().get(entry.getKey());
                if (cookie == null) {
                    return cookiePattern.nullSafeIsAbsent() ? MatchResult.exactMatch(new SubEvent[0]) : MatchResult.noMatch(new SubEvent[0]);
                }
                return cookie.getValues().stream().map(cookiePattern::match).max(Comparator.naturalOrder()).orElse(MatchResult.noMatch(new SubEvent[0]));
            }).collect(Collectors.toList()));
        }
        return MatchResult.exactMatch(new SubEvent[0]);
    }

    private MatchResult schemeMatches(Request request) {
        return this.scheme != null ? MatchResult.of(this.scheme.equals(request.getScheme()), new SubEvent[0]) : MatchResult.exactMatch(new SubEvent[0]);
    }

    private MatchResult hostMatches(Request request) {
        return this.host != null ? this.host.match(request.getHost()) : MatchResult.exactMatch(new SubEvent[0]);
    }

    private MatchResult portMatches(Request request) {
        return this.port != null ? MatchResult.of(request.getPort() == this.port.intValue(), new SubEvent[0]) : MatchResult.exactMatch(new SubEvent[0]);
    }

    private MatchResult allHeadersMatchResult(Request request) {
        Map<String, MultiValuePattern> combinedHeaders = this.combineBasicAuthAndOtherHeaders();
        if (combinedHeaders != null && !combinedHeaders.isEmpty()) {
            return MatchResult.aggregate(combinedHeaders.entrySet().stream().map(headerPattern -> ((MultiValuePattern)headerPattern.getValue()).match(request.header((String)headerPattern.getKey()))).collect(Collectors.toList()));
        }
        return MatchResult.exactMatch(new SubEvent[0]);
    }

    public Map<String, MultiValuePattern> combineBasicAuthAndOtherHeaders() {
        if (this.basicAuthCredentials == null) {
            return this.headers;
        }
        Map<String, MultiValuePattern> combinedHeaders = this.headers;
        HashMap<String, MultiValuePattern> allHeadersBuilder = new HashMap<String, MultiValuePattern>(ParameterUtils.getFirstNonNull(combinedHeaders, Collections.emptyMap()));
        allHeadersBuilder.put("Authorization", this.basicAuthCredentials.asAuthorizationMultiValuePattern());
        combinedHeaders = allHeadersBuilder;
        return combinedHeaders;
    }

    private MatchResult allQueryParamsMatch(Request request) {
        if (this.queryParams != null && !this.queryParams.isEmpty()) {
            return MatchResult.aggregate(this.queryParams.entrySet().stream().map(queryParamPattern -> ((MultiValuePattern)queryParamPattern.getValue()).match(request.queryParameter((String)queryParamPattern.getKey()))).collect(Collectors.toList()));
        }
        return MatchResult.exactMatch(new SubEvent[0]);
    }

    private MatchResult allFormParamsMatch(Request request) {
        if (this.formParams != null && !this.formParams.isEmpty()) {
            return MatchResult.aggregate(this.formParams.entrySet().stream().map(formParamPattern -> ((MultiValuePattern)formParamPattern.getValue()).match(request.formParameter((String)formParamPattern.getKey()))).collect(Collectors.toList()));
        }
        return MatchResult.exactMatch(new SubEvent[0]);
    }

    private MatchResult allPathParamsMatch(Request request) {
        if (this.url.getClass().equals(UrlPathTemplatePattern.class) && this.pathParams != null && !this.pathParams.isEmpty()) {
            UrlPathTemplatePattern urlPathTemplatePattern = (UrlPathTemplatePattern)this.url;
            PathTemplate pathTemplate = urlPathTemplatePattern.getPathTemplate();
            if (!pathTemplate.matches(request.getUrl())) {
                return MatchResult.noMatch(new SubEvent[0]);
            }
            PathParams requestPathParams = pathTemplate.parse(Urls.getPath(request.getUrl()));
            return MatchResult.aggregate(this.pathParams.entrySet().stream().map(entry -> ((StringValuePattern)entry.getValue()).match((String)requestPathParams.get(entry.getKey()))).collect(Collectors.toList()));
        }
        return MatchResult.exactMatch(new SubEvent[0]);
    }

    private MatchResult allBodyPatternsMatch(Request request) {
        if (this.bodyPatterns != null && !this.bodyPatterns.isEmpty() && request.getBody() != null) {
            return MatchResult.aggregate(this.bodyPatterns.stream().map(pattern -> {
                if (StringValuePattern.class.isAssignableFrom(pattern.getClass())) {
                    String body = StringUtils.isEmpty(request.getBodyAsString()) ? null : request.getBodyAsString();
                    return pattern.match(body);
                }
                return pattern.match(request.getBody());
            }).collect(Collectors.toList()));
        }
        return MatchResult.exactMatch(new SubEvent[0]);
    }

    private MatchResult allMultipartPatternsMatch(Request request) {
        if (this.multipartPatterns != null && !this.multipartPatterns.isEmpty()) {
            if (!request.isMultipart()) {
                return MatchResult.noMatch(new SubEvent[0]);
            }
            return MatchResult.aggregate(this.multipartPatterns.stream().map(pattern -> pattern.match(request)).collect(Collectors.toList()));
        }
        return MatchResult.exactMatch(new SubEvent[0]);
    }

    public boolean isMatchedBy(Request request, Map<String, RequestMatcherExtension> customMatchers) {
        return this.match(request, customMatchers).isExactMatch();
    }

    public String getScheme() {
        return this.scheme;
    }

    public StringValuePattern getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUrl() {
        return this.urlPatternOrNull(UrlPattern.class, false);
    }

    public String getUrlPattern() {
        return this.urlPatternOrNull(UrlPattern.class, true);
    }

    public String getUrlPath() {
        return this.urlPatternOrNull(UrlPathPattern.class, false);
    }

    public String getUrlPathPattern() {
        return this.urlPatternOrNull(UrlPathPattern.class, true);
    }

    public String getUrlPathTemplate() {
        return this.urlPatternOrNull(UrlPathTemplatePattern.class, false);
    }

    @JsonIgnore
    public UrlPattern getUrlMatcher() {
        return this.url;
    }

    private String urlPatternOrNull(Class<? extends UrlPattern> clazz, boolean regex) {
        return this.url != null && this.url.getClass().equals(clazz) && this.url.isRegex() == regex && this.url.isSpecified() ? (String)this.url.getPattern().getValue() : null;
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public Map<String, MultiValuePattern> getHeaders() {
        return this.headers;
    }

    public BasicCredentials getBasicAuthCredentials() {
        return this.basicAuthCredentials;
    }

    public Map<String, StringValuePattern> getPathParameters() {
        return this.pathParams;
    }

    public Map<String, MultiValuePattern> getQueryParameters() {
        return this.queryParams;
    }

    public Map<String, MultiValuePattern> getFormParameters() {
        return this.formParams;
    }

    public Map<String, StringValuePattern> getCookies() {
        return this.cookies;
    }

    public List<ContentPattern<?>> getBodyPatterns() {
        return this.bodyPatterns;
    }

    public CustomMatcherDefinition getCustomMatcher() {
        return this.customMatcherDefinition;
    }

    public List<MultipartValuePattern> getMultipartPatterns() {
        return this.multipartPatterns;
    }

    @JsonIgnore
    public ValueMatcher<Request> getMatcher() {
        return this.matcher;
    }

    @Override
    public String getName() {
        return "requestMatching";
    }

    @Override
    public String getExpected() {
        return this.toString();
    }

    public boolean hasInlineCustomMatcher() {
        return this.hasInlineCustomMatcher;
    }

    public boolean hasNamedCustomMatcher() {
        return this.customMatcherDefinition != null;
    }

    public boolean hasCustomMatcher() {
        return this.hasInlineCustomMatcher() || this.hasNamedCustomMatcher();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestPattern that = (RequestPattern)o;
        return this.hasInlineCustomMatcher == that.hasInlineCustomMatcher && Objects.equals(this.scheme, that.scheme) && Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port) && Objects.equals(this.url, that.url) && Objects.equals(this.method, that.method) && Objects.equals(this.headers, that.headers) && Objects.equals(this.queryParams, that.queryParams) && Objects.equals(this.cookies, that.cookies) && Objects.equals(this.basicAuthCredentials, that.basicAuthCredentials) && Objects.equals(this.bodyPatterns, that.bodyPatterns) && Objects.equals(this.multipartPatterns, that.multipartPatterns) && Objects.equals(this.customMatcherDefinition, that.customMatcherDefinition) && Objects.equals(this.matcher, that.matcher);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.host, this.port, this.url, this.method, this.headers, this.queryParams, this.cookies, this.basicAuthCredentials, this.bodyPatterns, this.multipartPatterns, this.customMatcherDefinition, this.matcher, this.hasInlineCustomMatcher);
    }

    public String toString() {
        return Json.write(this);
    }

    public static Predicate<Request> thatMatch(RequestPattern pattern) {
        return RequestPattern.thatMatch(pattern, Collections.emptyMap());
    }

    public static Predicate<Request> thatMatch(RequestPattern pattern, Map<String, RequestMatcherExtension> customMatchers) {
        return request -> pattern.match((Request)request, customMatchers).isExactMatch();
    }

    public static Predicate<ServeEvent> withRequestMatching(RequestPattern pattern) {
        return serveEvent -> pattern.match(serveEvent.getRequest()).isExactMatch();
    }
}

