/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.LinkedHashSet;
import java.util.Set;

public class MinMaxContainsValidator
extends BaseJsonValidator {
    private final Set<ValidationMessage> analysis = new LinkedHashSet<ValidationMessage>();

    public MinMaxContainsValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.MAX_CONTAINS, validationContext);
        JsonNode maxNode;
        int min2 = 1;
        int max = Integer.MAX_VALUE;
        JsonNode minNode = parentSchema.getSchemaNode().get("minContains");
        if (null != minNode) {
            if (!minNode.isNumber() || !minNode.canConvertToExactIntegral() || minNode.intValue() < 0) {
                this.report("minContains", schemaPath);
            } else {
                min2 = minNode.intValue();
            }
        }
        if (null != (maxNode = parentSchema.getSchemaNode().get("maxContains"))) {
            if (!maxNode.isNumber() || !maxNode.canConvertToExactIntegral() || maxNode.intValue() < 0) {
                this.report("maxContains", schemaPath);
            } else {
                max = maxNode.intValue();
            }
        }
        if (max < min2) {
            this.report("minContainsVsMaxContains", schemaPath);
        }
    }

    private void report(String messageKey, String at) {
        this.analysis.add(this.constructValidationMessage(messageKey, at, this.parentSchema.getSchemaNode().toString()));
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        return this.analysis;
    }
}

