/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Urls;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;

public class UniqueFilenameGenerator {
    public static String generate(String url, String prefix, String id) {
        return UniqueFilenameGenerator.generate(url, prefix, id, "json");
    }

    public static String generate(String url, String prefix, String id, String extension) {
        String pathPart = Urls.urlToPathParts(URI.create(url));
        String string = pathPart = pathPart.isBlank() ? "(root)" : UniqueFilenameGenerator.sanitise(pathPart);
        if (pathPart.length() > 150) {
            pathPart = StringUtils.truncate(pathPart, 150);
        }
        return prefix + "-" + pathPart + "-" + id + "." + extension;
    }

    private static String sanitise(String input) {
        return input.replaceAll("[,~:/?#\\[\\]@!\\$&'()*+;=]", "_");
    }
}

