/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty11;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class HttpsProxyDetectingHandler
extends AbstractHandler {
    public static final String IS_HTTPS_PROXY_REQUEST_ATTRIBUTE = "wiremock.isHttpsProxyRequest";
    private final ServerConnector mitmProxyConnector;

    public HttpsProxyDetectingHandler(ServerConnector mitmProxyConnector) {
        this.mitmProxyConnector = mitmProxyConnector;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        int httpsProxyPort = this.mitmProxyConnector.getLocalPort();
        if (request.getLocalPort() == httpsProxyPort) {
            request.setAttribute(IS_HTTPS_PROXY_REQUEST_ATTRIBUTE, true);
        }
    }
}

