/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extensions.state.extensions;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.core.ConfigurationException;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ServeEventListener;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RequestTemplateModel;
import com.github.tomakehurst.wiremock.extension.responsetemplating.TemplateEngine;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.wiremock.extensions.state.internal.ContextManager;
import org.wiremock.extensions.state.internal.ExtensionLogger;
import org.wiremock.extensions.state.internal.RecordStateParameters;
import org.wiremock.extensions.state.internal.ResponseTemplateModel;
import org.wiremock.extensions.state.internal.StateExtensionMixin;

public class RecordStateEventListener
implements ServeEventListener,
StateExtensionMixin {
    private final TemplateEngine templateEngine;
    private final ContextManager contextManager;

    public RecordStateEventListener(ContextManager contextManager, TemplateEngine templateEngine) {
        this.contextManager = contextManager;
        this.templateEngine = templateEngine;
    }

    @Override
    public void beforeResponseSent(ServeEvent serveEvent, Parameters parameters) {
        Map<String, Object> model = Map.of("request", RequestTemplateModel.from(serveEvent.getRequest()), "response", ResponseTemplateModel.from(serveEvent.getResponse()));
        RecordStateParameters configuration = Json.mapToObject(parameters, RecordStateParameters.class);
        String contextName = this.createContextName(model, parameters);
        this.handleState(contextName, model, configuration);
        this.handleList(contextName, model, configuration);
    }

    @Override
    public String getName() {
        return "recordState";
    }

    @Override
    public boolean applyGlobally() {
        return false;
    }

    private void handleState(String contextName, Map<String, Object> model, RecordStateParameters parameters) {
        Optional.ofNullable(parameters.getState()).ifPresent(configuration -> this.contextManager.createOrUpdateContextState(contextName, this.getPropertiesFromConfiguration(model, (Map<String, String>)configuration)));
    }

    private Map<String, String> getPropertiesFromConfiguration(Map<String, Object> model, Map<String, String> configuration) {
        return configuration.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), this.renderTemplate(model, (String)entry.getValue()))).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void handleList(String contextName, Map<String, Object> model, RecordStateParameters parameters) {
        Optional.ofNullable(parameters.getList()).ifPresent(listConfiguration -> {
            Optional.ofNullable(listConfiguration.getAddFirst()).ifPresent(configuration -> this.addFirst(contextName, model, (Map<String, String>)configuration));
            Optional.ofNullable(listConfiguration.getAddLast()).ifPresent(configuration -> this.addLast(contextName, model, (Map<String, String>)configuration));
        });
    }

    private Long addFirst(String contextName, Map<String, Object> model, Map<String, String> configuration) {
        return this.contextManager.createOrUpdateContextList(contextName, list -> {
            list.addFirst(this.getPropertiesFromConfiguration(model, configuration));
            ExtensionLogger.logger().info(contextName, "list::addFirst");
        });
    }

    private Long addLast(String contextName, Map<String, Object> model, Map<String, String> configuration) {
        return this.contextManager.createOrUpdateContextList(contextName, list -> {
            list.addLast(this.getPropertiesFromConfiguration(model, configuration));
            ExtensionLogger.logger().info(contextName, "list::addLast");
        });
    }

    private String createContextName(Map<String, Object> model, Parameters parameters) {
        String rawContext = Optional.ofNullable(parameters.getString("context")).filter(StringUtils::isNotBlank).orElseThrow(() -> new ConfigurationException("no context specified"));
        String context = this.renderTemplate(model, rawContext);
        if (StringUtils.isBlank(context)) {
            throw this.createConfigurationError("context cannot be blank", new String[0]);
        }
        return context;
    }

    private String renderTemplate(Object context, String value) {
        return this.templateEngine.getUncachedTemplate(value).apply(context);
    }
}

