/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extensions.state.extensions;

import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RequestTemplateModel;
import com.github.tomakehurst.wiremock.extension.responsetemplating.TemplateEngine;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.wiremock.extensions.state.internal.Context;
import org.wiremock.extensions.state.internal.ContextManager;
import org.wiremock.extensions.state.internal.ContextTemplateModel;
import org.wiremock.extensions.state.internal.ExtensionLogger;
import org.wiremock.extensions.state.internal.StateExtensionMixin;

public class StateRequestMatcher
extends RequestMatcherExtension
implements StateExtensionMixin {
    private final TemplateEngine templateEngine;
    private final ContextManager contextManager;

    public StateRequestMatcher(ContextManager contextManager, TemplateEngine templateEngine) {
        this.contextManager = contextManager;
        this.templateEngine = templateEngine;
    }

    private static List<Map.Entry<ContextMatcher, Object>> getMatches(Parameters parameters) {
        return parameters.entrySet().stream().filter(it -> ContextMatcher.from((String)it.getKey()) != null).map(it -> Map.entry(ContextMatcher.from((String)it.getKey()), it.getValue())).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public String getName() {
        return "state-matcher";
    }

    @Override
    public MatchResult match(Request request, Parameters parameters) {
        HashMap<String, RequestTemplateModel> model = new HashMap<String, RequestTemplateModel>(Map.of("request", RequestTemplateModel.from(request)));
        return Optional.ofNullable(parameters.getString("hasContext", null)).map(template -> this.hasContext((Map<String, Object>)model, parameters, (String)template)).or(() -> Optional.ofNullable(parameters.getString("hasNotContext", null)).map(template -> this.hasNotContext(model, (String)template))).orElseThrow(() -> this.createConfigurationError("Parameters should only contain 'hasContext' or 'hasNotContext'", new String[0]));
    }

    private MatchResult hasContext(Map<String, Object> model, Parameters parameters, String template) {
        return this.contextManager.getContext(this.renderTemplate(model, template)).map(context -> {
            List<Map.Entry<ContextMatcher, Object>> matchers = StateRequestMatcher.getMatches(parameters);
            if (matchers.isEmpty()) {
                ExtensionLogger.logger().info((Context)context, "hasContext matched");
                return MatchResult.exactMatch(new SubEvent[0]);
            }
            return this.calculateMatch(model, (Context)context, matchers);
        }).orElseGet(() -> MatchResult.noMatch(new SubEvent[0]));
    }

    private MatchResult calculateMatch(Map<String, Object> model, Context context, List<Map.Entry<ContextMatcher, Object>> matchers) {
        model.put("context", ContextTemplateModel.from(context));
        long result = matchers.stream().map(it -> ((ContextMatcher)((Object)((Object)it.getKey()))).evaluate(context, this.renderTemplate(model, it.getValue().toString()))).filter(it -> it == false).count();
        return MatchResult.partialMatch((double)result / (double)matchers.size());
    }

    private MatchResult hasNotContext(Map<String, Object> model, String template) {
        String context = this.renderTemplate(model, template);
        if (this.contextManager.getContext(context).isEmpty()) {
            ExtensionLogger.logger().info(context, "hasNotContext matched");
            return MatchResult.exactMatch(new SubEvent[0]);
        }
        return MatchResult.noMatch(new SubEvent[0]);
    }

    String renderTemplate(Object context, String value) {
        return this.templateEngine.getUncachedTemplate(value).apply(context);
    }

    private static enum ContextMatcher {
        hasProperty((c, stringValue) -> c.getProperties().containsKey(stringValue)),
        hasNotProperty((c, stringValue) -> !c.getProperties().containsKey(stringValue)),
        updateCountEqualTo((c, stringValue) -> ContextMatcher.withConvertedNumber(c, stringValue, (context, value) -> context.getUpdateCount().equals(value))),
        updateCountLessThan((c, stringValue) -> ContextMatcher.withConvertedNumber(c, stringValue, (context, value) -> context.getUpdateCount() < value)),
        updateCountMoreThan((c, stringValue) -> ContextMatcher.withConvertedNumber(c, stringValue, (context, value) -> context.getUpdateCount() > value)),
        listSizeEqualTo((c, stringValue) -> ContextMatcher.withConvertedNumber(c, stringValue, (context, value) -> (long)context.getList().size() == value)),
        listSizeLessThan((c, stringValue) -> ContextMatcher.withConvertedNumber(c, stringValue, (context, value) -> (long)context.getList().size() < value)),
        listSizeMoreThan((c, stringValue) -> ContextMatcher.withConvertedNumber(c, stringValue, (context, value) -> (long)context.getList().size() > value));

        private final BiFunction<Context, String, Boolean> evaluator;

        private ContextMatcher(BiFunction<Context, String, Boolean> evaluator) {
            this.evaluator = evaluator;
        }

        public static ContextMatcher from(String from) {
            return Arrays.stream(ContextMatcher.values()).filter(it -> it.name().equals(from)).findFirst().orElse(null);
        }

        private static boolean withConvertedNumber(Context context, String stringValue, BiFunction<Context, Long, Boolean> evaluator) {
            try {
                Long longValue = Long.valueOf(stringValue);
                return evaluator.apply(context, longValue);
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }

        public boolean evaluate(Context context, String value) {
            return this.evaluator.apply(context, value);
        }
    }
}

