/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class HttpHeadersJsonDeserializer
extends JsonDeserializer<HttpHeaders> {
    @Override
    public HttpHeaders deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode rootNode = (JsonNode)parser.readValueAsTree();
        Iterable all = rootNode::fields;
        List<HttpHeader> headers = StreamSupport.stream(all.spliterator(), false).map(entry -> HttpHeadersJsonDeserializer.createHttpHeader((String)entry.getKey(), (JsonNode)entry.getValue())).collect(Collectors.toList());
        return new HttpHeaders(headers);
    }

    private static HttpHeader createHttpHeader(String key, JsonNode fieldValue) {
        if (fieldValue.isArray()) {
            Iterable all = fieldValue::elements;
            List<String> headerValues = StreamSupport.stream(all.spliterator(), false).map(JsonNode::textValue).collect(Collectors.toList());
            return new HttpHeader(key, (Collection<String>)headerValues);
        }
        return new HttpHeader(key, fieldValue.textValue());
    }

    public static <T> Iterable<T> all(Iterator<T> underlyingIterator) {
        return () -> underlyingIterator;
    }
}

