/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.tomakehurst.wiremock.common.ContentTypes;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;
import com.github.tomakehurst.wiremock.recording.ResponseDefinitionBodyMatcherDeserializer;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import java.util.Objects;

@JsonDeserialize(using=ResponseDefinitionBodyMatcherDeserializer.class)
public class ResponseDefinitionBodyMatcher
implements ValueMatcher<ResponseDefinition> {
    public static final long DEFAULT_MAX_TEXT_SIZE = 10240L;
    public static final long DEFAULT_MAX_BINARY_SIZE = 0L;
    private final long textSizeThreshold;
    private final long binarySizeThreshold;

    public ResponseDefinitionBodyMatcher(long textSizeThreshold, long binarySizeThreshold) {
        this.textSizeThreshold = textSizeThreshold;
        this.binarySizeThreshold = binarySizeThreshold;
    }

    public String getTextSizeThreshold() {
        return String.valueOf(this.textSizeThreshold);
    }

    public String getBinarySizeThreshold() {
        return String.valueOf(this.binarySizeThreshold);
    }

    @Override
    public MatchResult match(ResponseDefinition responseDefinition) {
        if (!responseDefinition.specifiesBodyContent()) {
            return MatchResult.noMatch(new SubEvent[0]);
        }
        if (responseDefinition.getHeaders() != null && ContentTypes.determineIsTextFromMimeType(responseDefinition.getHeaders().getContentTypeHeader().mimeTypePart())) {
            if ((long)responseDefinition.getTextBody().length() > this.textSizeThreshold) {
                return MatchResult.exactMatch(new SubEvent[0]);
            }
            return MatchResult.noMatch(new SubEvent[0]);
        }
        if ((long)responseDefinition.getByteBody().length > this.binarySizeThreshold) {
            return MatchResult.exactMatch(new SubEvent[0]);
        }
        return MatchResult.noMatch(new SubEvent[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseDefinitionBodyMatcher that = (ResponseDefinitionBodyMatcher)o;
        return Objects.equals(this.textSizeThreshold, that.textSizeThreshold) && Objects.equals(this.binarySizeThreshold, that.binarySizeThreshold);
    }

    public int hashCode() {
        return Objects.hash(this.textSizeThreshold, this.binarySizeThreshold);
    }
}

