/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extensions.state.extensions;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.JsonException;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.wiremock.extensions.state.internal.ContextManager;
import org.wiremock.extensions.state.internal.ExtensionLogger;
import org.wiremock.extensions.state.internal.model.Context;
import wiremock.com.github.jknack.handlebars.Options;

public class StateHandlerbarHelper
extends HandlebarsHelper<Object> {
    private final ContextManager contextManager;

    public StateHandlerbarHelper(ContextManager contextManager) {
        this.contextManager = contextManager;
    }

    @Override
    public Object apply(Object o, Options options) {
        String contextName = (String)options.hash("context");
        String property = (String)options.hash("property");
        String list = (String)options.hash("list");
        String defaultValue = (String)options.hash("default");
        if (StringUtils.isEmpty(contextName)) {
            return this.handleError("'context' cannot be empty");
        }
        if (StringUtils.isNotBlank(property) == StringUtils.isNotBlank(list)) {
            return this.handleError("Either 'property' or 'list' has to be set");
        }
        if (StringUtils.isNotBlank(property)) {
            return this.getProperty(contextName, property, defaultValue).orElseGet(() -> {
                ExtensionLogger.logger().info(contextName, String.format("property '%s' not found, using `null`", property));
                return "";
            });
        }
        return this.getList(contextName, list).orElseGet(() -> Optional.ofNullable(defaultValue).orElseGet(() -> {
            ExtensionLogger.logger().info(contextName, "list not found, using `null`");
            return "";
        }));
    }

    private Optional<Object> getProperty(String contextName, String property, String defaultValue) {
        return this.contextManager.getContextCopy(contextName).map(context -> Stream.of(SpecialProperties.values()).filter(it -> it.name().equals(property)).findFirst().map(it -> it.getFromContext((Context)context)).orElseGet(() -> context.getProperties().get(property))).or(() -> this.convertToPropertySpecificDefault(contextName, property, defaultValue)).map(obj -> {
            ExtensionLogger.logger().info(contextName, String.format("handlebar(property=%s)", property));
            return obj;
        });
    }

    private Optional<Object> convertToPropertySpecificDefault(String contextName, String property, String defaultValue) {
        return Stream.of(SpecialProperties.values()).filter(it -> it.name().equals(property)).findFirst().map(specialProperty -> Optional.ofNullable(defaultValue).map(it -> specialProperty.convertDefaultValue(contextName, (String)it)).orElseGet(() -> specialProperty.getBuiltInDefault(contextName))).or(() -> Optional.ofNullable(defaultValue));
    }

    private Optional<Object> getList(String contextName, String list) {
        return this.contextManager.getContextCopy(contextName).flatMap(context -> {
            try {
                return Optional.of(JsonPath.read(context.getList(), list, new Predicate[0]));
            }
            catch (PathNotFoundException e) {
                ExtensionLogger.logger().info(contextName, "Path query failed: " + e.getMessage());
                return Optional.empty();
            }
        }).map(obj -> {
            ExtensionLogger.logger().info(contextName, "handlebar(list)");
            return obj;
        });
    }

    private static enum SpecialProperties {
        updateCount(Context::getUpdateCount, contextName -> 0, (contextName, it) -> it),
        listSize(context -> context.getList().size(), contextName -> 0, (contextName, it) -> it),
        list(Context::getList, contextName -> List.of(), (contextName, defaultValue) -> Optional.ofNullable(defaultValue).map(it -> {
            try {
                return Json.read(it, ArrayList.class);
            }
            catch (JsonException ex) {
                ExtensionLogger.logger().error((String)contextName, "default for list property is not a JSON list - fallback to empty list: " + defaultValue);
                return null;
            }
        }).or(() -> Optional.of(new ArrayList())).map(it -> it).get());

        private final Function<Context, Object> contextExtractor;
        private final Function<String, Object> builtInDefault;
        private final BiFunction<String, String, Object> defaultConverter;

        private SpecialProperties(Function<Context, Object> contextExtractor, Function<String, Object> builtInDefault, BiFunction<String, String, Object> defaultConverter) {
            this.contextExtractor = contextExtractor;
            this.builtInDefault = builtInDefault;
            this.defaultConverter = defaultConverter;
        }

        public Object getFromContext(Context context) {
            return this.contextExtractor.apply(context);
        }

        public Object convertDefaultValue(String contextName, String defaultValue) {
            ExtensionLogger.logger().info(contextName, String.format("property '%s' using configured default value", this.name()));
            return this.defaultConverter.apply(contextName, defaultValue);
        }

        public Object getBuiltInDefault(String contextName) {
            ExtensionLogger.logger().info(contextName, String.format("property '%s' using built-in default value", this.name()));
            return this.builtInDefault.apply(contextName);
        }
    }
}

