/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.builder.javax_jaxb;

import java.beans.Introspector;
import java.lang.reflect.Method;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.util.JAXBSource;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.xmlunit.XMLUnitException;
import org.xmlunit.builder.JaxbBuilder;

public class JavaxJaxbBuilder
extends JaxbBuilder {
    protected JavaxJaxbBuilder(Object object) {
        super(object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Source build() {
        try {
            Marshaller marshaller;
            Object baseMarshaller = this.getMarshaller();
            if (baseMarshaller != null) {
                if (!(baseMarshaller instanceof Marshaller)) throw new XMLUnitException("provided Marshaller must be a " + Marshaller.class.getName());
                marshaller = (Marshaller)baseMarshaller;
            } else {
                marshaller = this.createDefaultMarshaller();
            }
            Object jaxbObject = this.getPreparedJaxbObject();
            JAXBSource jaxbSource = new JAXBSource(marshaller, jaxbObject);
            jaxbSource.setInputSource(null);
            return jaxbSource;
        }
        catch (JAXBException e) {
            throw new DataBindingException((Throwable)e);
        }
    }

    private Object getPreparedJaxbObject() {
        Class<?> clazz;
        XmlRootElement r;
        JAXBElement<Object> object = this.getObject();
        JAXBElement<Object> jaxbObject = object instanceof JAXBElement ? object : ((r = (clazz = object.getClass()).getAnnotation(XmlRootElement.class)) == null ? (this.getUseObjectFactory() ? JavaxJaxbBuilder.createJAXBElement(object) : JavaxJaxbBuilder.createInferredJAXBElement(object)) : object);
        return jaxbObject;
    }

    private Marshaller createDefaultMarshaller() throws JAXBException, PropertyException {
        JAXBContext context;
        Object object = this.getObject();
        if (object instanceof JAXBElement) {
            context = JAXBContext.newInstance((Class[])new Class[]{((JAXBElement)object).getDeclaredType()});
        } else {
            Class<?> clazz = object.getClass();
            context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        }
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        return marshaller;
    }

    private static <T> JAXBElement<T> createInferredJAXBElement(T object) {
        Class<?> clazz = object.getClass();
        return new JAXBElement(new QName(JavaxJaxbBuilder.inferName(clazz)), clazz, object);
    }

    private static <T> JAXBElement<T> createJAXBElement(T jaxbObj) {
        JAXBElement<T> jaxbElementFromObjectFactory = JavaxJaxbBuilder.createJaxbElementFromObjectFactory(jaxbObj);
        if (jaxbElementFromObjectFactory == null) {
            return JavaxJaxbBuilder.createInferredJAXBElement(jaxbObj);
        }
        return jaxbElementFromObjectFactory;
    }

    private static <T> JAXBElement<T> createJaxbElementFromObjectFactory(T obj) {
        try {
            Class<?> objFactClass = JavaxJaxbBuilder.getObjectFactoryClass(obj);
            Object objFact = objFactClass.newInstance();
            Method[] methods = objFactClass.getMethods();
            Object jaxbObj = null;
            for (Method method : methods) {
                Class<?>[] params = method.getParameterTypes();
                if (params.length != 1 || params[0] != obj.getClass() || !method.getReturnType().isAssignableFrom(JAXBElement.class)) continue;
                jaxbObj = method.invoke(objFact, obj);
                break;
            }
            return (JAXBElement)jaxbObj;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static <T> Class<?> getObjectFactoryClass(T obj) throws ClassNotFoundException {
        String objFactClassName = obj.getClass().getPackage().getName() + ".ObjectFactory";
        return Thread.currentThread().getContextClassLoader().loadClass(objFactClassName);
    }

    private static String inferName(Class clazz) {
        return Introspector.decapitalize(clazz.getSimpleName());
    }
}

