/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extensions.state.extensions;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.core.ConfigurationException;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ServeEventListener;
import com.github.tomakehurst.wiremock.extension.WireMockServices;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RequestTemplateModel;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.wiremock.extensions.state.internal.ContextManager;
import org.wiremock.extensions.state.internal.ExtensionLogger;
import org.wiremock.extensions.state.internal.StateExtensionMixin;
import org.wiremock.extensions.state.internal.api.RecordStateParameters;
import org.wiremock.extensions.state.internal.model.ResponseTemplateModel;
import wiremock.org.apache.commons.lang3.StringUtils;

public class RecordStateEventListener
implements ServeEventListener,
StateExtensionMixin {
    private final WireMockServices wireMockServices;
    private final ContextManager contextManager;

    public RecordStateEventListener(ContextManager contextManager, WireMockServices services) {
        this.contextManager = contextManager;
        this.wireMockServices = services;
    }

    public void beforeResponseSent(ServeEvent serveEvent, Parameters parameters) {
        Map<String, Object> model = Map.of("request", RequestTemplateModel.from((Request)serveEvent.getRequest()), "response", ResponseTemplateModel.from(serveEvent.getResponse()));
        RecordStateParameters configuration = (RecordStateParameters)Json.mapToObject((Map)parameters, RecordStateParameters.class);
        new ListenerInstance(serveEvent.getId().toString(), model, configuration).run();
    }

    public String getName() {
        return "recordState";
    }

    public boolean applyGlobally() {
        return false;
    }

    private String renderTemplate(Object context, String value) {
        return this.wireMockServices.getTemplateEngine().getUncachedTemplate(value).apply(context);
    }

    private class ListenerInstance {
        private final String requestId;
        private final RecordStateParameters parameters;
        private final Map<String, Object> model;
        private final String contextName;

        ListenerInstance(String requestId, Map<String, Object> model, RecordStateParameters parameters) {
            this.requestId = requestId;
            this.model = model;
            this.parameters = parameters;
            this.contextName = this.createContextName();
        }

        void run() {
            this.handleState();
            this.handleList();
        }

        private String createContextName() {
            String rawContext = Optional.ofNullable(this.parameters.getContext()).filter(StringUtils::isNotBlank).orElseThrow(() -> new ConfigurationException("no context specified"));
            String context = RecordStateEventListener.this.renderTemplate(this.model, rawContext);
            if (StringUtils.isBlank(context)) {
                throw RecordStateEventListener.this.createConfigurationError("context cannot be blank", new String[0]);
            }
            return context;
        }

        private void handleState() {
            Optional.ofNullable(this.parameters.getState()).ifPresent(configuration -> RecordStateEventListener.this.contextManager.createOrUpdateContextState(this.requestId, this.contextName, this.getPropertiesFromConfiguration((Map<String, String>)configuration)));
        }

        private Map<String, String> getPropertiesFromConfiguration(Map<String, String> configuration) {
            return configuration.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), RecordStateEventListener.this.renderTemplate(this.model, (String)entry.getValue()))).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        private void handleList() {
            Optional.ofNullable(this.parameters.getList()).ifPresent(listConfiguration -> {
                Optional.ofNullable(listConfiguration.getAddFirst()).ifPresent(this::addFirst);
                Optional.ofNullable(listConfiguration.getAddLast()).ifPresent(this::addLast);
            });
        }

        private void addFirst(Map<String, String> configuration) {
            RecordStateEventListener.this.contextManager.createOrUpdateContextList(this.requestId, this.contextName, list -> {
                list.addFirst(this.getPropertiesFromConfiguration(configuration));
                ExtensionLogger.logger().info(this.contextName, "list::addFirst");
            });
        }

        private void addLast(Map<String, String> configuration) {
            RecordStateEventListener.this.contextManager.createOrUpdateContextList(this.requestId, this.contextName, list -> {
                list.addLast(this.getPropertiesFromConfiguration(configuration));
                ExtensionLogger.logger().info(this.contextName, "list::addLast");
            });
        }
    }
}

