/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extensions.state;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.tomakehurst.wiremock.store.Store;
import java.time.Duration;
import java.util.Optional;
import java.util.stream.Stream;

public class CaffeineStore
implements Store<String, Object> {
    private static final int DEFAULT_EXPIRATION_SECONDS = 3600;
    private final Cache<String, Object> cache;

    public CaffeineStore() {
        this(0);
    }

    public CaffeineStore(int expirationSeconds) {
        Caffeine<Object, Object> builder = Caffeine.newBuilder();
        if (expirationSeconds == 0) {
            builder.expireAfterWrite(Duration.ofSeconds(3600L));
        } else {
            builder.expireAfterWrite(Duration.ofSeconds(expirationSeconds));
        }
        this.cache = builder.build();
    }

    public Stream<String> getAllKeys() {
        return this.cache.asMap().keySet().stream();
    }

    public Optional<Object> get(String key) {
        return Optional.ofNullable(this.cache.getIfPresent(key));
    }

    public void put(String key, Object content) {
        this.cache.put(key, content);
    }

    public void remove(String key) {
        this.cache.invalidate(key);
    }

    public void clear() {
        this.cache.invalidateAll();
    }
}

