/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extensions.state;

import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.ExtensionFactory;
import com.github.tomakehurst.wiremock.extension.WireMockServices;
import com.github.tomakehurst.wiremock.extension.responsetemplating.TemplateEngine;
import com.github.tomakehurst.wiremock.store.Store;
import java.util.Collections;
import java.util.List;
import org.wiremock.extensions.state.extensions.DeleteStateEventListener;
import org.wiremock.extensions.state.extensions.RecordStateEventListener;
import org.wiremock.extensions.state.extensions.StateRequestMatcher;
import org.wiremock.extensions.state.extensions.StateTemplateHelperProviderExtension;
import org.wiremock.extensions.state.extensions.TransactionEventListener;
import org.wiremock.extensions.state.internal.ContextManager;
import org.wiremock.extensions.state.internal.TransactionManager;

public class StateExtension
implements ExtensionFactory {
    private final StateTemplateHelperProviderExtension stateTemplateHelperProviderExtension;
    private final RecordStateEventListener recordStateEventListener;
    private final DeleteStateEventListener deleteStateEventListener;
    private final TransactionEventListener transactionEventListener;
    private final StateRequestMatcher stateRequestMatcher;

    public StateExtension(Store<String, Object> store) {
        TransactionManager transactionManager = new TransactionManager(store);
        ContextManager contextManager = new ContextManager(store, transactionManager);
        this.stateTemplateHelperProviderExtension = new StateTemplateHelperProviderExtension(contextManager);
        TemplateEngine templateEngine = new TemplateEngine(this.stateTemplateHelperProviderExtension.provideTemplateHelpers(), null, Collections.emptySet(), false);
        this.recordStateEventListener = new RecordStateEventListener(contextManager, templateEngine);
        this.deleteStateEventListener = new DeleteStateEventListener(contextManager, templateEngine);
        this.transactionEventListener = new TransactionEventListener(transactionManager);
        this.stateRequestMatcher = new StateRequestMatcher(contextManager, templateEngine);
    }

    @Override
    public List<Extension> create(WireMockServices services) {
        return List.of(this.recordStateEventListener, this.deleteStateEventListener, this.transactionEventListener, this.stateRequestMatcher, this.stateTemplateHelperProviderExtension);
    }
}

