/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.spring.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.wiremock.spring.ConfigureWireMock;
import org.wiremock.spring.EnableWireMock;
import org.wiremock.spring.internal.WireMockContextCustomizer;

public class WireMockContextCustomizerFactory
implements ContextCustomizerFactory {
    static final ConfigureWireMock DEFAULT_CONFIGURE_WIREMOCK = DefaultConfigureWireMock.class.getAnnotation(ConfigureWireMock.class);

    static ConfigureWireMock[] getConfigureWireMocksOrDefault(ConfigureWireMock ... value) {
        if (value == null || value.length == 0) {
            return new ConfigureWireMock[]{DEFAULT_CONFIGURE_WIREMOCK};
        }
        return value;
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        ConfigureWiremockHolder holder = new ConfigureWiremockHolder();
        this.parseDefinitions(testClass, holder);
        if (holder.isEmpty()) {
            return null;
        }
        return new WireMockContextCustomizer(holder.asArray());
    }

    private void parseDefinitions(Class<?> testClass, ConfigureWiremockHolder parser) {
        parser.parse(testClass);
        if (TestContextAnnotationUtils.searchEnclosingClass(testClass)) {
            this.parseDefinitions(testClass.getEnclosingClass(), parser);
        }
    }

    private static class ConfigureWiremockHolder {
        private final List<ConfigureWireMock> annotations = new ArrayList<ConfigureWireMock>();

        private ConfigureWiremockHolder() {
        }

        void add(ConfigureWireMock ... annotations) {
            this.annotations.addAll(Arrays.asList(annotations));
        }

        void parse(Class<?> clazz) {
            EnableWireMock annotation = (EnableWireMock)AnnotationUtils.findAnnotation(clazz, EnableWireMock.class);
            if (annotation != null) {
                this.add(WireMockContextCustomizerFactory.getConfigureWireMocksOrDefault(annotation.value()));
            }
        }

        boolean isEmpty() {
            return this.annotations.isEmpty();
        }

        ConfigureWireMock[] asArray() {
            return this.annotations.toArray(new ConfigureWireMock[0]);
        }
    }

    @ConfigureWireMock(name="wiremock")
    private static class DefaultConfigureWireMock {
        private DefaultConfigureWireMock() {
        }
    }
}

