/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.spring.internal;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Function;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.wiremock.spring.ConfigureWireMock;
import org.wiremock.spring.EnableWireMock;
import org.wiremock.spring.InjectWireMock;
import org.wiremock.spring.internal.Store;
import org.wiremock.spring.internal.WireMockContextCustomizerFactory;

public class WireMockSpringJunitExtension
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(WireMockSpringJunitExtension.class);

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        Store.INSTANCE.findAllInstances(extensionContext).forEach(WireMockServer::resetAll);
        WireMockSpringJunitExtension.injectWireMockInstances(extensionContext, InjectWireMock.class, InjectWireMock::value);
        this.configureWireMockForDefaultInstance(extensionContext);
    }

    private void configureWireMockForDefaultInstance(ExtensionContext extensionContext) {
        List instances = extensionContext.getRequiredTestInstances().getAllInstances();
        WireMockServer wiremock = null;
        String wireMockName = null;
        for (Object instance : instances) {
            EnableWireMock enableWireMockAnnotation = (EnableWireMock)AnnotationUtils.findAnnotation(instance.getClass(), EnableWireMock.class);
            if (enableWireMockAnnotation == null) continue;
            ConfigureWireMock[] wireMockServers = WireMockContextCustomizerFactory.getConfigureWireMocksOrDefault(enableWireMockAnnotation.value());
            if (wireMockServers.length > 1) {
                LOGGER.info("Not configuring WireMock for default instance when several ConfigureWireMock (" + wireMockServers.length + ")");
            }
            if (wiremock != null) {
                LOGGER.info("Not configuring WireMock for default instance when several candidates found");
                return;
            }
            wireMockName = wireMockServers[0].name();
            wiremock = Store.INSTANCE.findRequiredWireMockInstance(extensionContext, wireMockName);
        }
        if (wiremock != null) {
            LOGGER.info("Configuring WireMock for default instance, '" + wireMockName + "' on '" + wiremock.port() + "'.");
            WireMock.configureFor((int)wiremock.port());
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        WireMock.configureFor((int)8080);
    }

    private static <T extends Annotation> void injectWireMockInstances(ExtensionContext extensionContext, Class<T> annotation, Function<T, String> fn) throws IllegalAccessException {
        for (Object testInstance : extensionContext.getRequiredTestInstances().getAllInstances()) {
            List annotatedFields = AnnotationSupport.findAnnotatedFields(testInstance.getClass(), annotation);
            for (Field annotatedField : annotatedFields) {
                T annotationValue = annotatedField.getAnnotation(annotation);
                annotatedField.setAccessible(true);
                WireMockServer wiremock = Store.INSTANCE.findRequiredWireMockInstance(extensionContext, fn.apply(annotationValue));
                annotatedField.set(testInstance, wiremock);
            }
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return parameterContext.getParameter().getType() == WireMockServer.class && parameterContext.isAnnotated(InjectWireMock.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        String wireMockServerName = ((InjectWireMock)parameterContext.findAnnotation(InjectWireMock.class).get()).value();
        return Store.INSTANCE.findRequiredWireMockInstance(extensionContext, wireMockServerName);
    }
}

