/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.admin.AdminRoutes;
import com.github.tomakehurst.wiremock.admin.AdminTask;
import com.github.tomakehurst.wiremock.admin.FindStubMappingsByMetadataTask;
import com.github.tomakehurst.wiremock.admin.GetAllScenariosTask;
import com.github.tomakehurst.wiremock.admin.GetGlobalSettingsTask;
import com.github.tomakehurst.wiremock.admin.GetRecordingStatusTask;
import com.github.tomakehurst.wiremock.admin.ImportStubMappingsTask;
import com.github.tomakehurst.wiremock.admin.RemoveServeEventTask;
import com.github.tomakehurst.wiremock.admin.RemoveServeEventsByRequestPatternTask;
import com.github.tomakehurst.wiremock.admin.RemoveServeEventsByStubMetadataTask;
import com.github.tomakehurst.wiremock.admin.RemoveStubMappingsByMetadataTask;
import com.github.tomakehurst.wiremock.admin.RequestSpec;
import com.github.tomakehurst.wiremock.admin.SetScenarioStateTask;
import com.github.tomakehurst.wiremock.admin.StartRecordingTask;
import com.github.tomakehurst.wiremock.admin.StopRecordingTask;
import com.github.tomakehurst.wiremock.admin.model.GetGlobalSettingsResult;
import com.github.tomakehurst.wiremock.admin.model.GetScenariosResult;
import com.github.tomakehurst.wiremock.admin.model.GetServeEventsResult;
import com.github.tomakehurst.wiremock.admin.model.ListStubMappingsResult;
import com.github.tomakehurst.wiremock.admin.model.ScenarioState;
import com.github.tomakehurst.wiremock.admin.model.ServeEventQuery;
import com.github.tomakehurst.wiremock.admin.model.SingleServedStubResult;
import com.github.tomakehurst.wiremock.admin.model.SingleStubMappingResult;
import com.github.tomakehurst.wiremock.admin.tasks.CreateStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.EditStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindNearMissesForRequestPatternTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindNearMissesForRequestTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindNearMissesForUnmatchedTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindRequestsTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindUnmatchedRequestsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetAllRequestsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetAllStubMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetRequestCountTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetServedStubTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetUnmatchedStubMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GlobalSettingsUpdateTask;
import com.github.tomakehurst.wiremock.admin.tasks.RemoveMatchingStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.RemoveStubMappingByIdTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetRequestsTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetScenariosTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetStubMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetToDefaultMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.SaveMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.ShutdownServerTask;
import com.github.tomakehurst.wiremock.admin.tasks.SnapshotTask;
import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.common.AdminException;
import com.github.tomakehurst.wiremock.common.ClientError;
import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.HttpClientUtils;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.JsonException;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.url.PathParams;
import com.github.tomakehurst.wiremock.common.url.QueryParams;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpStatus;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.recording.RecordSpec;
import com.github.tomakehurst.wiremock.recording.RecordSpecBuilder;
import com.github.tomakehurst.wiremock.recording.RecordingStatusResult;
import com.github.tomakehurst.wiremock.recording.SnapshotRecordResult;
import com.github.tomakehurst.wiremock.security.ClientAuthenticator;
import com.github.tomakehurst.wiremock.security.NoClientAuthenticator;
import com.github.tomakehurst.wiremock.security.NotAuthorisedException;
import com.github.tomakehurst.wiremock.stubbing.StubImport;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.FindNearMissesResult;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.FindServeEventsResult;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;

public class HttpAdminClient
implements Admin {
    private static final String ADMIN_URL_PREFIX = "%s://%s%s%s/__admin";
    private static final int NO_PORT_DEFINED = -1;
    private final String scheme;
    private final String host;
    private final int port;
    private final String urlPathPrefix;
    private final String hostHeader;
    private final ClientAuthenticator authenticator;
    private final AdminRoutes adminRoutes;
    private final CloseableHttpClient httpClient;

    public HttpAdminClient(String scheme, String host, int port) {
        this(scheme, host, port, "");
    }

    public HttpAdminClient(String scheme, String host) {
        this(scheme, host, -1, "");
    }

    public HttpAdminClient(String host, int port, String urlPathPrefix) {
        this("http", host, port, urlPathPrefix);
    }

    public HttpAdminClient(String scheme, String host, int port, String urlPathPrefix) {
        this(scheme, host, port, urlPathPrefix, null, null, 0, NoClientAuthenticator.noClientAuthenticator());
    }

    public HttpAdminClient(String scheme, String host, int port, String urlPathPrefix, String hostHeader) {
        this(scheme, host, port, urlPathPrefix, hostHeader, null, 0, NoClientAuthenticator.noClientAuthenticator());
    }

    public HttpAdminClient(String scheme, String host, int port, String urlPathPrefix, String hostHeader, String proxyHost, int proxyPort) {
        this(scheme, host, port, urlPathPrefix, hostHeader, proxyHost, proxyPort, NoClientAuthenticator.noClientAuthenticator());
    }

    public HttpAdminClient(String scheme, String host, int port, String urlPathPrefix, String hostHeader, String proxyHost, int proxyPort, ClientAuthenticator authenticator) {
        this(scheme, host, port, urlPathPrefix, hostHeader, authenticator, HttpClientFactory.createClient(HttpAdminClient.createProxySettings(proxyHost, proxyPort)));
    }

    public HttpAdminClient(String scheme, String host, int port, String urlPathPrefix, String hostHeader, ClientAuthenticator authenticator, CloseableHttpClient httpClient) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.urlPathPrefix = urlPathPrefix;
        this.hostHeader = hostHeader;
        this.authenticator = authenticator;
        this.httpClient = httpClient;
        this.adminRoutes = AdminRoutes.forClient();
    }

    public HttpAdminClient(String host, int port) {
        this(host, port, "");
    }

    private static StringEntity jsonStringEntity(String json) {
        return new StringEntity(json, StandardCharsets.UTF_8);
    }

    @Override
    public void addStubMapping(StubMapping stubMapping) {
        if (stubMapping.getRequest().hasInlineCustomMatcher()) {
            throw new AdminException("Custom matchers can't be used when administering a remote WireMock server. Use WireMockRule.stubFor() or WireMockServer.stubFor() to administer the local instance.");
        }
        this.executeRequest(this.adminRoutes.requestSpecForTask(CreateStubMappingTask.class), PathParams.empty(), stubMapping, Void.class);
    }

    @Override
    public void editStubMapping(StubMapping stubMapping) {
        this.putJsonAssertOkAndReturnBody(this.urlFor(EditStubMappingTask.class, PathParams.single("id", stubMapping.getId().toString())), Json.write(stubMapping));
    }

    @Override
    public void removeStubMapping(StubMapping stubbMapping) {
        this.postJsonAssertOkAndReturnBody(this.urlFor(RemoveMatchingStubMappingTask.class), Json.write(stubbMapping));
    }

    @Override
    public void removeStubMapping(UUID id) {
        this.executeRequest(this.adminRoutes.requestSpecForTask(RemoveStubMappingByIdTask.class), PathParams.single("id", id), Void.class);
    }

    @Override
    public ListStubMappingsResult listAllStubMappings() {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetAllStubMappingsTask.class), ListStubMappingsResult.class);
    }

    @Override
    public SingleStubMappingResult getStubMapping(UUID id) {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetStubMappingTask.class), PathParams.single("id", id), SingleStubMappingResult.class);
    }

    @Override
    public void saveMappings() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(SaveMappingsTask.class), null);
    }

    @Override
    public void resetAll() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(ResetTask.class), null);
    }

    @Override
    public void resetRequests() {
        this.executeRequest(this.adminRoutes.requestSpecForTask(ResetRequestsTask.class));
    }

    @Override
    public void resetScenarios() {
        this.executeRequest(this.adminRoutes.requestSpecForTask(ResetScenariosTask.class));
    }

    @Override
    public void resetMappings() {
        this.executeRequest(this.adminRoutes.requestSpecForTask(ResetStubMappingsTask.class));
    }

    @Override
    public void resetToDefaultMappings() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(ResetToDefaultMappingsTask.class), null);
    }

    @Override
    public GetServeEventsResult getServeEvents() {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetAllRequestsTask.class), GetServeEventsResult.class);
    }

    @Override
    public GetServeEventsResult getServeEvents(ServeEventQuery query) {
        QueryParams queryParams = new QueryParams();
        queryParams.add("unmatched", String.valueOf(query.isOnlyUnmatched()));
        if (query.getStubMappingId() != null) {
            queryParams.add("matchingStub", query.getStubMappingId().toString());
        }
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetAllRequestsTask.class), PathParams.empty(), queryParams, null, GetServeEventsResult.class);
    }

    @Override
    public SingleServedStubResult getServedStub(UUID id) {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetServedStubTask.class), PathParams.single("id", id), SingleServedStubResult.class);
    }

    @Override
    public VerificationResult countRequestsMatching(RequestPattern requestPattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(GetRequestCountTask.class), Json.write(requestPattern));
        return VerificationResult.from(body);
    }

    @Override
    public FindRequestsResult findRequestsMatching(RequestPattern requestPattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(FindRequestsTask.class), Json.write(requestPattern));
        return Json.read(body, FindRequestsResult.class);
    }

    @Override
    public FindRequestsResult findUnmatchedRequests() {
        String body = this.getJsonAssertOkAndReturnBody(this.urlFor(FindUnmatchedRequestsTask.class));
        return Json.read(body, FindRequestsResult.class);
    }

    @Override
    public void removeServeEvent(UUID eventId) {
        this.executeRequest(this.adminRoutes.requestSpecForTask(RemoveServeEventTask.class), PathParams.single("id", eventId), Void.class);
    }

    @Override
    public FindServeEventsResult removeServeEventsMatching(RequestPattern requestPattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(RemoveServeEventsByRequestPatternTask.class), Json.write(requestPattern));
        return Json.read(body, FindServeEventsResult.class);
    }

    @Override
    public FindServeEventsResult removeServeEventsForStubsMatchingMetadata(StringValuePattern metadataPattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(RemoveServeEventsByStubMetadataTask.class), Json.write(metadataPattern));
        return Json.read(body, FindServeEventsResult.class);
    }

    @Override
    public FindNearMissesResult findNearMissesForUnmatchedRequests() {
        String body = this.getJsonAssertOkAndReturnBody(this.urlFor(FindNearMissesForUnmatchedTask.class));
        return Json.read(body, FindNearMissesResult.class);
    }

    @Override
    public GetScenariosResult getAllScenarios() {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetAllScenariosTask.class), GetScenariosResult.class);
    }

    @Override
    public void resetScenario(String name) {
        this.executeRequest(this.adminRoutes.requestSpecForTask(SetScenarioStateTask.class), PathParams.single("name", name), Void.class);
    }

    @Override
    public void setScenarioState(String name, String state) {
        this.executeRequest(this.adminRoutes.requestSpecForTask(SetScenarioStateTask.class), PathParams.single("name", name), new ScenarioState(state), Void.class);
    }

    @Override
    public FindNearMissesResult findTopNearMissesFor(LoggedRequest loggedRequest) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(FindNearMissesForRequestTask.class), Json.write(loggedRequest));
        return Json.read(body, FindNearMissesResult.class);
    }

    @Override
    public FindNearMissesResult findTopNearMissesFor(RequestPattern requestPattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(FindNearMissesForRequestPatternTask.class), Json.write(requestPattern));
        return Json.read(body, FindNearMissesResult.class);
    }

    @Override
    public void updateGlobalSettings(GlobalSettings settings) {
        this.postJsonAssertOkAndReturnBody(this.urlFor(GlobalSettingsUpdateTask.class), Json.write(settings));
    }

    @Override
    public SnapshotRecordResult snapshotRecord() {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(SnapshotTask.class), "");
        return Json.read(body, SnapshotRecordResult.class);
    }

    @Override
    public SnapshotRecordResult snapshotRecord(RecordSpecBuilder spec) {
        return this.snapshotRecord(spec.build());
    }

    @Override
    public SnapshotRecordResult snapshotRecord(RecordSpec spec) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(SnapshotTask.class), Json.write(spec));
        return Json.read(body, SnapshotRecordResult.class);
    }

    @Override
    public void startRecording(String targetBaseUrl) {
        this.startRecording(RecordSpec.forBaseUrl(targetBaseUrl));
    }

    @Override
    public void startRecording(RecordSpec recordSpec) {
        this.postJsonAssertOkAndReturnBody(this.urlFor(StartRecordingTask.class), Json.write(recordSpec));
    }

    @Override
    public void startRecording(RecordSpecBuilder recordSpec) {
        this.startRecording(recordSpec.build());
    }

    @Override
    public SnapshotRecordResult stopRecording() {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(StopRecordingTask.class), "");
        return Json.read(body, SnapshotRecordResult.class);
    }

    @Override
    public RecordingStatusResult getRecordingStatus() {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetRecordingStatusTask.class), RecordingStatusResult.class);
    }

    @Override
    public Options getOptions() {
        return new WireMockConfiguration().port(this.port).bindAddress(this.host);
    }

    @Override
    public void shutdownServer() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(ShutdownServerTask.class), null);
    }

    @Override
    public ListStubMappingsResult findUnmatchedStubs() {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetUnmatchedStubMappingsTask.class), ListStubMappingsResult.class);
    }

    @Override
    public ListStubMappingsResult findAllStubsByMetadata(StringValuePattern pattern) {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(FindStubMappingsByMetadataTask.class), pattern, ListStubMappingsResult.class);
    }

    @Override
    public void removeStubsByMetadata(StringValuePattern pattern) {
        this.executeRequest(this.adminRoutes.requestSpecForTask(RemoveStubMappingsByMetadataTask.class), pattern, Void.class);
    }

    @Override
    public void importStubs(StubImport stubImport) {
        this.executeRequest(this.adminRoutes.requestSpecForTask(ImportStubMappingsTask.class), stubImport, Void.class);
    }

    @Override
    public GetGlobalSettingsResult getGlobalSettings() {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetGlobalSettingsTask.class), GetGlobalSettingsResult.class);
    }

    public int port() {
        return this.port;
    }

    private static ProxySettings createProxySettings(String proxyHost, int proxyPort) {
        if (Strings.isNotBlank(proxyHost)) {
            return new ProxySettings(proxyHost, proxyPort);
        }
        return ProxySettings.NO_PROXY;
    }

    private String postJsonAssertOkAndReturnBody(String url, String json) {
        HttpPost post = new HttpPost(url);
        post.addHeader("Content-Type", (Object)"application/json");
        post.setEntity((HttpEntity)HttpAdminClient.jsonStringEntity(Optional.ofNullable(json).orElse("")));
        return this.safelyExecuteRequest(url, (ClassicHttpRequest)post);
    }

    private String putJsonAssertOkAndReturnBody(String url, String json) {
        HttpPut put = new HttpPut(url);
        put.addHeader("Content-Type", (Object)"application/json");
        put.setEntity((HttpEntity)HttpAdminClient.jsonStringEntity(Optional.ofNullable(json).orElse("")));
        return this.safelyExecuteRequest(url, (ClassicHttpRequest)put);
    }

    protected String getJsonAssertOkAndReturnBody(String url) {
        HttpGet get = new HttpGet(url);
        return this.safelyExecuteRequest(url, (ClassicHttpRequest)get);
    }

    private void executeRequest(RequestSpec requestSpec) {
        this.executeRequest(requestSpec, PathParams.empty(), null, Void.class);
    }

    private <B, R> R executeRequest(RequestSpec requestSpec, B requestBody, Class<R> responseType) {
        return this.executeRequest(requestSpec, PathParams.empty(), requestBody, responseType);
    }

    private <B, R> R executeRequest(RequestSpec requestSpec, Class<R> responseType) {
        return this.executeRequest(requestSpec, PathParams.empty(), null, responseType);
    }

    private <B, R> R executeRequest(RequestSpec requestSpec, PathParams pathParams, Class<R> responseType) {
        return this.executeRequest(requestSpec, pathParams, null, responseType);
    }

    private <B, R> R executeRequest(RequestSpec requestSpec, PathParams pathParams, B requestBody, Class<R> responseType) {
        return this.executeRequest(requestSpec, pathParams, QueryParams.EMPTY, requestBody, responseType);
    }

    private <B, R> R executeRequest(RequestSpec requestSpec, PathParams pathParams, QueryParams queryParams, B requestBody, Class<R> responseType) {
        String url = this.getAdminUrl(requestSpec.path(pathParams) + String.valueOf(queryParams));
        ClassicRequestBuilder requestBuilder = ClassicRequestBuilder.create((String)requestSpec.method().getName()).setUri(url);
        if (requestSpec.method().hasEntity()) {
            requestBuilder.setEntity((HttpEntity)HttpAdminClient.jsonStringEntity(Optional.ofNullable(requestBody).map(Json::write).orElse("")));
            requestBuilder.addHeader("Content-Type", "application/json");
        }
        String responseBodyString = this.safelyExecuteRequest(url, requestBuilder.build());
        return responseType == Void.class ? null : (R)Json.read(responseBodyString, responseType);
    }

    private void injectHeaders(ClassicHttpRequest request) {
        if (this.hostHeader != null) {
            request.addHeader("Host", (Object)this.hostHeader);
        }
        List<HttpHeader> httpHeaders = this.authenticator.generateAuthHeaders();
        for (HttpHeader header : httpHeaders) {
            for (String value : header.values()) {
                request.addHeader(header.key(), (Object)value);
            }
        }
    }

    private void verifyResponseStatus(String url, int responseStatusCode) {
        if (HttpStatus.isServerError(responseStatusCode)) {
            throw new VerificationException(this.responseStatusErrorMessage(url, responseStatusCode));
        }
        if (responseStatusCode == 401) {
            throw new NotAuthorisedException(this.responseStatusErrorMessage(url, responseStatusCode));
        }
    }

    private String responseStatusErrorMessage(String url, int responseStatusCode) {
        return "Expected status 2xx for " + url + " but was " + responseStatusCode;
    }

    private String safelyExecuteRequest(String url, ClassicHttpRequest request) {
        String string;
        block9: {
            this.injectHeaders(request);
            CloseableHttpResponse response = this.httpClient.execute(request);
            try {
                int statusCode = response.getCode();
                this.verifyResponseStatus(url, statusCode);
                String body = HttpClientUtils.getEntityAsStringAndCloseStream((ClassicHttpResponse)response);
                if (HttpStatus.isClientError(statusCode)) {
                    this.throwParsedClientError(url, body, statusCode);
                }
                string = body;
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return Exceptions.throwUnchecked(e, String.class);
                }
            }
            response.close();
        }
        return string;
    }

    private void throwParsedClientError(String url, String responseBody, int responseStatusCode) {
        Errors errors;
        try {
            errors = Json.read(responseBody, Errors.class);
        }
        catch (JsonException e) {
            Errors.Error jsonError = e.getErrors().first();
            String jsonErrorDetail = jsonError.getDetail();
            String extendedDetail = "Error parsing response body '" + responseBody + "' with status code " + responseStatusCode + " for " + url + ". Error: " + jsonErrorDetail;
            errors = Errors.single(jsonError.getCode(), jsonError.getSource().getPointer(), jsonError.getTitle(), extendedDetail);
        }
        throw ClientError.fromErrors(errors);
    }

    private String urlFor(Class<? extends AdminTask> taskClass) {
        return this.urlFor(taskClass, PathParams.empty());
    }

    private String urlFor(Class<? extends AdminTask> taskClass, PathParams pathParams) {
        RequestSpec requestSpec = this.adminRoutes.requestSpecForTask(taskClass);
        Objects.requireNonNull(requestSpec, "No admin task URL is registered for " + taskClass.getSimpleName());
        return this.getAdminUrl(requestSpec.path(pathParams));
    }

    private String getAdminUrl(String pathSuffix) {
        String portPart = this.port == -1 ? "" : ":" + this.port;
        return String.format(ADMIN_URL_PREFIX + pathSuffix, this.scheme, this.host, portPart, this.urlPathPrefix);
    }
}

