/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.jknack.handlebars.EscapingStrategy;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.helper.AssignHelper;
import com.github.jknack.handlebars.helper.ConditionalHelpers;
import com.github.jknack.handlebars.helper.NumberHelper;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.ListOrSingle;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.TemplateModelDataProviderExtension;
import com.github.tomakehurst.wiremock.extension.responsetemplating.HandlebarsOptimizedTemplate;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RequestLine;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RequestPartTemplateModel;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RequestTemplateModel;
import com.github.tomakehurst.wiremock.extension.responsetemplating.SystemKeyAuthoriser;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.SystemValueHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.WireMockHelpers;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.MultiValue;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public class TemplateEngine {
    private final Handlebars handlebars;
    private final Cache<Object, HandlebarsOptimizedTemplate> cache;
    private final Long maxCacheEntries;
    private final List<TemplateModelDataProviderExtension> templateModelDataProviders;

    public static TemplateEngine defaultTemplateEngine() {
        return new TemplateEngine(Collections.emptyMap(), null, null, false, Collections.emptyList());
    }

    public TemplateEngine(Map<String, Helper<?>> helpers, Long maxCacheEntries, Set<String> permittedSystemKeys, boolean escapingDisabled, List<TemplateModelDataProviderExtension> templateModelDataProviders) {
        this.handlebars = escapingDisabled ? new Handlebars().with(EscapingStrategy.NOOP) : new Handlebars();
        this.maxCacheEntries = maxCacheEntries;
        this.templateModelDataProviders = templateModelDataProviders;
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (maxCacheEntries != null) {
            cacheBuilder.maximumSize(maxCacheEntries.longValue());
        }
        this.cache = cacheBuilder.build();
        this.addHelpers(helpers, permittedSystemKeys);
    }

    protected TemplateEngine() {
        this.handlebars = null;
        this.maxCacheEntries = null;
        this.cache = null;
        this.templateModelDataProviders = Collections.emptyList();
    }

    private void addHelpers(Map<String, Helper<?>> helpers, Set<String> permittedSystemKeys) {
        for (StringHelpers stringHelpers : StringHelpers.values()) {
            if (stringHelpers.name().equals("now")) continue;
            this.handlebars.registerHelper(stringHelpers.name(), (Helper)stringHelpers);
        }
        for (StringHelpers stringHelpers : NumberHelper.values()) {
            this.handlebars.registerHelper(stringHelpers.name(), (Helper)stringHelpers);
        }
        for (StringHelpers stringHelpers : ConditionalHelpers.values()) {
            this.handlebars.registerHelper(stringHelpers.name(), (Helper)stringHelpers);
        }
        this.handlebars.registerHelper("assign", (Helper)new AssignHelper());
        for (StringHelpers stringHelpers : WireMockHelpers.values()) {
            this.handlebars.registerHelper(stringHelpers.name(), (Helper)stringHelpers);
        }
        this.handlebars.registerHelper("systemValue", (Helper)new SystemValueHelper(new SystemKeyAuthoriser(permittedSystemKeys)));
        for (Map.Entry entry : helpers.entrySet()) {
            this.handlebars.registerHelper((String)entry.getKey(), (Helper)entry.getValue());
        }
    }

    public HandlebarsOptimizedTemplate getTemplate(Object key, String content) {
        if (this.maxCacheEntries != null && this.maxCacheEntries < 1L) {
            return this.getUncachedTemplate(content);
        }
        try {
            return (HandlebarsOptimizedTemplate)this.cache.get(key, () -> new HandlebarsOptimizedTemplate(this.handlebars, content));
        }
        catch (ExecutionException e) {
            return Exceptions.throwUnchecked(e, HandlebarsOptimizedTemplate.class);
        }
    }

    public HandlebarsOptimizedTemplate getUncachedTemplate(String content) {
        return new HandlebarsOptimizedTemplate(this.handlebars, content);
    }

    public Map<String, Object> buildModelForRequest(ServeEvent serveEvent) {
        ResponseDefinition responseDefinition = serveEvent.getResponseDefinition();
        Parameters parameters = ParameterUtils.getFirstNonNull(responseDefinition.getTransformerParameters(), Parameters.empty());
        Map<String, Object> additionalModelData = this.templateModelDataProviders.stream().map(provider -> provider.provideTemplateModelData(serveEvent).entrySet()).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("parameters", parameters);
        model.put("request", TemplateEngine.buildRequestModel(serveEvent.getRequest()));
        model.putAll(additionalModelData);
        return model;
    }

    public Map<String, Object> buildModelForRequest(Request request) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("request", TemplateEngine.buildRequestModel(request));
        return model;
    }

    private static RequestTemplateModel buildRequestModel(Request request) {
        RequestLine requestLine = RequestLine.fromRequest(request);
        TreeMap<String, ListOrSingle<String>> adaptedHeaders = new TreeMap<String, ListOrSingle<String>>(String.CASE_INSENSITIVE_ORDER);
        adaptedHeaders.putAll((Map<String, ListOrSingle<String>>)Maps.toMap(request.getAllHeaderKeys(), input -> ListOrSingle.of(request.header((String)input).values())));
        Map adaptedCookies = Maps.transformValues(request.getCookies(), cookie -> ListOrSingle.of(cookie.getValues()));
        return new RequestTemplateModel(request.getId() != null ? request.getId().toString() : null, requestLine, adaptedHeaders, adaptedCookies, request.isMultipart(), Body.ofBinaryOrText(request.getBody(), request.contentTypeHeader()), TemplateEngine.buildRequestPartModel(request));
    }

    private static Map<String, RequestPartTemplateModel> buildRequestPartModel(Request request) {
        if (request.isMultipart()) {
            boolean isMultipartRelated;
            String contentType = request.getHeader("Content-Type");
            boolean bl = isMultipartRelated = contentType != null && contentType.contains("multipart/related");
            if (isMultipartRelated) {
                HashMap<String, RequestPartTemplateModel> result = new HashMap<String, RequestPartTemplateModel>();
                int partIndex = 0;
                for (Request.Part part2 : request.getParts()) {
                    Object key = part2.getName() != null ? part2.getName() : "part-" + partIndex++;
                    result.put((String)key, new RequestPartTemplateModel((String)key, part2.getHeaders().all().stream().collect(Collectors.toMap(MultiValue::key, header -> ListOrSingle.of(header.values()))), part2.getBody()));
                }
                return result;
            }
            return request.getParts().stream().collect(Collectors.toMap(Request.Part::getName, part -> new RequestPartTemplateModel(part.getName(), part.getHeaders().all().stream().collect(Collectors.toMap(MultiValue::key, header -> ListOrSingle.of(header.values()))), part.getBody())));
        }
        return Collections.emptyMap();
    }

    public long getCacheSize() {
        return this.cache.size();
    }

    public void invalidateCache() {
        this.cache.invalidateAll();
    }

    public Long getMaxCacheEntries() {
        return this.maxCacheEntries;
    }
}

