/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.common.Json;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;

public class HelperUtils {
    static final Configuration jsonPathConfig = Configuration.defaultConfiguration().addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL}).jsonProvider((JsonProvider)new JacksonJsonProvider(Json.getObjectMapper()));

    public static Integer coerceToInt(Object value) {
        if (value == null) {
            return null;
        }
        if (Number.class.isAssignableFrom(value.getClass())) {
            return ((Number)value).intValue();
        }
        if (CharSequence.class.isAssignableFrom(value.getClass())) {
            return Integer.parseInt(value.toString());
        }
        return null;
    }

    public static Double coerceToDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (Number.class.isAssignableFrom(value.getClass())) {
            return ((Number)value).doubleValue();
        }
        if (CharSequence.class.isAssignableFrom(value.getClass())) {
            return Double.parseDouble(value.toString());
        }
        return null;
    }
}

