/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.NetworkAddressRules;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSettings;
import com.github.tomakehurst.wiremock.core.Version;
import com.github.tomakehurst.wiremock.http.NetworkAddressRulesAdheringDnsResolver;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ssl.HostVerifyingSSLSocketFactory;
import com.github.tomakehurst.wiremock.http.ssl.SSLContextBuilder;
import com.github.tomakehurst.wiremock.http.ssl.TrustEverythingStrategy;
import com.github.tomakehurst.wiremock.http.ssl.TrustSelfSignedStrategy;
import com.github.tomakehurst.wiremock.http.ssl.TrustSpecificHostsStrategy;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpTrace;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class HttpClientFactory {
    public static final int DEFAULT_MAX_CONNECTIONS = 50;
    public static final int DEFAULT_TIMEOUT = 30000;

    public static CloseableHttpClient createClient(int maxConnections, int timeoutMilliseconds, ProxySettings proxySettings, KeyStoreSettings trustStoreSettings, boolean trustAllCertificates, List<String> trustedHosts, boolean useSystemProperties, NetworkAddressRules networkAddressRules, boolean disableConnectionReuse, String userAgent) {
        NetworkAddressRulesAdheringDnsResolver dnsResolver = new NetworkAddressRulesAdheringDnsResolver(networkAddressRules);
        HttpClientBuilder builder = HttpClientBuilder.create().disableAuthCaching().disableAutomaticRetries().disableCookieManagement().disableRedirectHandling().disableContentCompression().setDefaultRequestConfig(RequestConfig.custom().setResponseTimeout(Timeout.ofMilliseconds((long)timeoutMilliseconds)).setProtocolUpgradeEnabled(false).build());
        Object effectiveUserAgent = userAgent != null ? userAgent : "WireMock " + Version.getCurrentVersion();
        builder.setUserAgent((String)effectiveUserAgent);
        if (disableConnectionReuse) {
            builder.setConnectionReuseStrategy((request, response, context) -> false).setKeepAliveStrategy((response, context) -> TimeValue.ZERO_MILLISECONDS);
        }
        if (useSystemProperties) {
            builder.useSystemProperties();
        }
        if (proxySettings != ProxySettings.NO_PROXY) {
            HttpHost proxyHost = new HttpHost(proxySettings.host(), proxySettings.port());
            builder.setProxy(proxyHost);
            if (Strings.isNotEmpty(proxySettings.getUsername()) && Strings.isNotEmpty(proxySettings.getPassword())) {
                builder.setProxyAuthenticationStrategy((AuthenticationStrategy)new DefaultAuthenticationStrategy());
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxySettings.host(), proxySettings.port()), (Credentials)new UsernamePasswordCredentials(proxySettings.getUsername(), proxySettings.getPassword().toCharArray()));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
        SSLContext sslContext = HttpClientFactory.buildSslContext(trustStoreSettings, trustAllCertificates, trustedHosts);
        LayeredConnectionSocketFactory sslSocketFactory = HttpClientFactory.buildSslConnectionSocketFactory(sslContext);
        builder.setConnectionManager((HttpClientConnectionManager)PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory(sslSocketFactory).setDnsResolver((DnsResolver)dnsResolver).setMaxConnPerRoute(maxConnections).setMaxConnTotal(maxConnections).setValidateAfterInactivity(TimeValue.ofSeconds((long)5L)).setConnectionFactory((HttpConnectionFactory)new ManagedHttpClientConnectionFactory(null, CharCodingConfig.custom().setCharset(StandardCharsets.UTF_8).build(), null)).build());
        return builder.build();
    }

    private static LayeredConnectionSocketFactory buildSslConnectionSocketFactory(SSLContext sslContext) {
        String[] supportedProtocols = HttpClientFactory.split(System.getProperty("https.protocols"));
        String[] supportedCipherSuites = HttpClientFactory.split(System.getProperty("https.cipherSuites"));
        return new SSLConnectionSocketFactory((SSLSocketFactory)new HostVerifyingSSLSocketFactory(sslContext.getSocketFactory()), supportedProtocols, supportedCipherSuites, (HostnameVerifier)new NoopHostnameVerifier());
    }

    private static String[] split(String s) {
        if (TextUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return s.split(" *, *");
    }

    private static SSLContext buildSslContext(KeyStoreSettings trustStoreSettings, boolean trustAllCertificates, List<String> trustedHosts) {
        if (trustStoreSettings != KeyStoreSettings.NO_STORE) {
            return HttpClientFactory.buildSSLContextWithTrustStore(trustStoreSettings, trustAllCertificates, trustedHosts);
        }
        if (trustAllCertificates) {
            return HttpClientFactory.buildAllowAnythingSSLContext();
        }
        try {
            return SSLContextBuilder.create().loadTrustMaterial(new TrustSpecificHostsStrategy(trustedHosts)).build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            return (SSLContext)Exceptions.throwUnchecked(e, null);
        }
    }

    public static CloseableHttpClient createClient(int maxConnections, int timeoutMilliseconds, ProxySettings proxySettings, KeyStoreSettings trustStoreSettings, boolean useSystemProperties, NetworkAddressRules networkAddressRules, boolean disableConnectionReuse) {
        return HttpClientFactory.createClient(maxConnections, timeoutMilliseconds, proxySettings, trustStoreSettings, true, Collections.emptyList(), useSystemProperties, networkAddressRules, disableConnectionReuse, null);
    }

    public static CloseableHttpClient createClient(int maxConnections, int timeoutMilliseconds, ProxySettings proxySettings, KeyStoreSettings trustStoreSettings, boolean useSystemProperties, NetworkAddressRules networkAddressRules, boolean disableConnectionReuse, String userAgent) {
        return HttpClientFactory.createClient(maxConnections, timeoutMilliseconds, proxySettings, trustStoreSettings, true, Collections.emptyList(), useSystemProperties, networkAddressRules, disableConnectionReuse, userAgent);
    }

    private static SSLContext buildSSLContextWithTrustStore(KeyStoreSettings trustStoreSettings, boolean trustSelfSignedCertificates, List<String> trustedHosts) {
        try {
            KeyStore trustStore = trustStoreSettings.loadStore();
            SSLContextBuilder sslContextBuilder = SSLContextBuilder.create().loadKeyMaterial(trustStore, trustStoreSettings.password().toCharArray());
            if (trustSelfSignedCertificates) {
                sslContextBuilder.loadTrustMaterial(new TrustSelfSignedStrategy());
            } else if (HttpClientFactory.containsCertificate(trustStore)) {
                sslContextBuilder.loadTrustMaterial(trustStore, new TrustSpecificHostsStrategy(trustedHosts));
            } else {
                sslContextBuilder.loadTrustMaterial(new TrustSpecificHostsStrategy(trustedHosts));
            }
            return sslContextBuilder.build();
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, SSLContext.class);
        }
    }

    private static boolean containsCertificate(KeyStore trustStore) throws KeyStoreException {
        Enumeration<String> aliases = trustStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            try {
                if (!(trustStore.getEntry(alias, null) instanceof KeyStore.TrustedCertificateEntry)) continue;
                return true;
            }
            catch (NoSuchAlgorithmException | UnrecoverableEntryException generalSecurityException) {
            }
        }
        return false;
    }

    private static SSLContext buildAllowAnythingSSLContext() {
        try {
            return SSLContextBuilder.create().loadTrustMaterial(new TrustEverythingStrategy()).build();
        }
        catch (Exception e) {
            return (SSLContext)Exceptions.throwUnchecked(e, null);
        }
    }

    public static CloseableHttpClient createClient(int maxConnections, int timeoutMilliseconds) {
        return HttpClientFactory.createClient(maxConnections, timeoutMilliseconds, ProxySettings.NO_PROXY, KeyStoreSettings.NO_STORE, true, NetworkAddressRules.ALLOW_ALL, false);
    }

    public static CloseableHttpClient createClient(int timeoutMilliseconds) {
        return HttpClientFactory.createClient(50, timeoutMilliseconds);
    }

    public static CloseableHttpClient createClient(ProxySettings proxySettings) {
        return HttpClientFactory.createClient(50, 30000, proxySettings, KeyStoreSettings.NO_STORE, true, NetworkAddressRules.ALLOW_ALL, false);
    }

    public static CloseableHttpClient createClient() {
        return HttpClientFactory.createClient(30000);
    }

    public static HttpUriRequest getHttpRequestFor(RequestMethod method, String url) {
        LocalNotifier.notifier().info("Proxying: " + String.valueOf(method) + " " + url);
        if (method.equals(RequestMethod.GET)) {
            return new HttpGet(url);
        }
        if (method.equals(RequestMethod.POST)) {
            return new HttpPost(url);
        }
        if (method.equals(RequestMethod.PUT)) {
            return new HttpPut(url);
        }
        if (method.equals(RequestMethod.DELETE)) {
            return new HttpDelete(url);
        }
        if (method.equals(RequestMethod.HEAD)) {
            return new HttpHead(url);
        }
        if (method.equals(RequestMethod.OPTIONS)) {
            return new HttpOptions(url);
        }
        if (method.equals(RequestMethod.TRACE)) {
            return new HttpTrace(url);
        }
        if (method.equals(RequestMethod.PATCH)) {
            return new HttpPatch(url);
        }
        return new HttpUriRequestBase(method.toString(), URI.create(url));
    }
}

