/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class RequestCache {
    private static RequestCache OFF = new RequestCache(){

        @Override
        public void put(Key key, Object value) {
        }

        @Override
        public <T> T get(Key key) {
            return null;
        }

        @Override
        public <T> T get(Key key, Supplier<T> supplier) {
            return supplier.get();
        }
    };
    private static final ThreadLocal<RequestCache> current = new ThreadLocal();
    private final Map<Key, Object> cache = new HashMap<Key, Object>();

    public static RequestCache getCurrent() {
        RequestCache requestCache = current.get();
        if (requestCache == null) {
            requestCache = new RequestCache();
            current.set(requestCache);
        }
        return requestCache;
    }

    public static void onRequestEnd() {
        current.remove();
    }

    public static void disable() {
        current.set(OFF);
    }

    public void put(Key key, Object value) {
        this.cache.put(key, value);
    }

    public <T> T get(Key key) {
        return (T)this.cache.get(key);
    }

    public <T> T get(Key key, Supplier<T> supplier) {
        return (T)this.cache.computeIfAbsent(key, k -> supplier.get());
    }

    public static class Key {
        private final Class<?> forClass;
        private final List<?> elements;

        public static Key keyFor(Class<?> forClass, Object ... elements) {
            return new Key(forClass, Arrays.asList(elements));
        }

        private Key(Class<?> forClass, List<?> elements) {
            this.forClass = forClass;
            this.elements = elements;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Key{");
            sb.append("forClass=").append(this.forClass);
            sb.append(", elements=").append(this.elements);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.forClass.equals(key.forClass) && this.elements.equals(key.elements);
        }

        public int hashCode() {
            return Objects.hash(this.forClass, this.elements);
        }
    }
}

