/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.common.Pair;
import com.github.tomakehurst.wiremock.recording.ResponseDefinitionBodyMatcher;
import com.github.tomakehurst.wiremock.recording.ScenarioProcessor;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingBodyExtractor;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingTransformerRunner;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.google.common.collect.HashMultiset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SnapshotStubMappingPostProcessor {
    private final boolean shouldRecordRepeatsAsScenarios;
    private final SnapshotStubMappingTransformerRunner transformerRunner;
    private final ResponseDefinitionBodyMatcher bodyExtractMatcher;
    private final SnapshotStubMappingBodyExtractor bodyExtractor;

    public SnapshotStubMappingPostProcessor(boolean shouldRecordRepeatsAsScenarios, SnapshotStubMappingTransformerRunner transformerRunner, ResponseDefinitionBodyMatcher bodyExtractMatcher, SnapshotStubMappingBodyExtractor bodyExtractor) {
        this.shouldRecordRepeatsAsScenarios = shouldRecordRepeatsAsScenarios;
        this.transformerRunner = transformerRunner;
        this.bodyExtractMatcher = bodyExtractMatcher;
        this.bodyExtractor = bodyExtractor;
    }

    public List<StubMapping> process(List<Pair<ServeEvent, StubMapping>> serveEventsToStubMappings) {
        List<StubMapping> transformedStubMappings = serveEventsToStubMappings.stream().map(this.transformerRunner).filter(Objects::nonNull).toList();
        HashMultiset requestCounts = HashMultiset.create();
        ArrayList<StubMapping> processedStubMappings = new ArrayList<StubMapping>();
        for (StubMapping transformedStubMapping : transformedStubMappings) {
            requestCounts.add((Object)transformedStubMapping.getRequest());
            if (requestCounts.count((Object)transformedStubMapping.getRequest()) > 1 && !this.shouldRecordRepeatsAsScenarios) continue;
            processedStubMappings.add(transformedStubMapping);
        }
        if (this.shouldRecordRepeatsAsScenarios) {
            new ScenarioProcessor().putRepeatedRequestsInScenarios(processedStubMappings);
        }
        this.extractStubMappingBodies(processedStubMappings);
        return processedStubMappings;
    }

    private void extractStubMappingBodies(List<StubMapping> stubMappings) {
        if (this.bodyExtractMatcher == null) {
            return;
        }
        for (StubMapping stubMapping : stubMappings) {
            if (!this.bodyExtractMatcher.match(stubMapping.getResponse()).isExactMatch()) continue;
            this.bodyExtractor.extractInPlace(stubMapping);
        }
    }
}

