/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.grpc.internal;

import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.HttpServer;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.jetty12.Jetty12HttpServer;
import com.github.tomakehurst.wiremock.store.BlobStore;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.EnumSet;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.wiremock.grpc.internal.GrpcFilter;
import org.wiremock.grpc.internal.GrpcHttpServerFactory;

public class Jetty12GrpcHttpServerFactory
extends GrpcHttpServerFactory {
    public Jetty12GrpcHttpServerFactory(BlobStore protoDescriptorStore) {
        super(protoDescriptorStore);
    }

    public String getName() {
        return "grpc-jetty12";
    }

    public HttpServer buildHttpServer(Options options, AdminRequestHandler adminRequestHandler, final StubRequestHandler stubRequestHandler) {
        return new Jetty12HttpServer(options, adminRequestHandler, stubRequestHandler){

            protected void decorateMockServiceContextBeforeConfig(ServletContextHandler mockServiceContext) {
                Jetty12GrpcHttpServerFactory.this.grpcFilter = new GrpcFilter(stubRequestHandler);
                Jetty12GrpcHttpServerFactory.this.loadFileDescriptors();
                FilterHolder filterHolder = new FilterHolder((Filter)Jetty12GrpcHttpServerFactory.this.grpcFilter);
                mockServiceContext.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
            }
        };
    }
}

