/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.grpc.dsl;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.http.DelayDistribution;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.FixedDelayDistribution;
import com.github.tomakehurst.wiremock.http.LogNormal;
import com.github.tomakehurst.wiremock.http.UniformDistribution;
import org.wiremock.annotations.Beta;
import org.wiremock.grpc.dsl.WireMockGrpc;

@Beta(justification="Incubating extension: https://github.com/wiremock/wiremock/issues/2383")
public class GrpcResponseDefinitionBuilder {
    public static final String GRPC_STATUS_NAME = "grpc-status-name";
    public static final String GRPC_STATUS_REASON = "grpc-status-reason";
    private final WireMockGrpc.Status grpcStatus;
    private final String statusReason;
    private final Fault fault;
    private String json;
    private boolean templatingEnabled;
    private DelayDistribution delay;

    public GrpcResponseDefinitionBuilder(WireMockGrpc.Status grpcStatus) {
        this(grpcStatus, null);
    }

    public GrpcResponseDefinitionBuilder(WireMockGrpc.Status grpcStatus, String statusReason) {
        this.grpcStatus = grpcStatus;
        this.statusReason = statusReason;
        this.fault = null;
    }

    public GrpcResponseDefinitionBuilder(Fault fault) {
        this.fault = fault;
        this.grpcStatus = null;
        this.statusReason = null;
    }

    public GrpcResponseDefinitionBuilder fromJson(String json) {
        this.json = json;
        return this;
    }

    public GrpcResponseDefinitionBuilder withTemplatingEnabled(boolean enabled) {
        this.templatingEnabled = enabled;
        return this;
    }

    public GrpcResponseDefinitionBuilder withFixedDelay(long milliseconds) {
        this.delay = new FixedDelayDistribution(milliseconds);
        return this;
    }

    public GrpcResponseDefinitionBuilder withRandomDelay(DelayDistribution distribution) {
        this.delay = distribution;
        return this;
    }

    public GrpcResponseDefinitionBuilder withLogNormalRandomDelay(double medianMilliseconds, double sigma) {
        return this.withRandomDelay(new LogNormal(medianMilliseconds, sigma));
    }

    public GrpcResponseDefinitionBuilder withUniformRandomDelay(int lowerMilliseconds, int upperMilliseconds) {
        return this.withRandomDelay(new UniformDistribution(lowerMilliseconds, upperMilliseconds));
    }

    public ResponseDefinitionBuilder build() {
        if (this.fault != null) {
            return ResponseDefinitionBuilder.responseDefinition().withFault(this.fault);
        }
        ResponseDefinitionBuilder responseDefinitionBuilder = ResponseDefinitionBuilder.responseDefinition().withHeader(GRPC_STATUS_NAME, this.grpcStatus.name());
        if (this.statusReason != null) {
            responseDefinitionBuilder.withHeader(GRPC_STATUS_REASON, this.statusReason);
        }
        if (this.templatingEnabled) {
            responseDefinitionBuilder.withTransformers("response-template");
        }
        if (this.delay != null) {
            responseDefinitionBuilder.withRandomDelay(this.delay);
        }
        return responseDefinitionBuilder.withBody(this.json);
    }
}

