/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.grpc.dsl;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import org.wiremock.annotations.Beta;
import org.wiremock.grpc.dsl.GrpcResponseDefinitionBuilder;
import org.wiremock.grpc.dsl.GrpcStubMappingBuilder;
import org.wiremock.grpc.internal.JsonMessageUtils;
import wiremock.com.fasterxml.jackson.databind.node.ObjectNode;
import wiremock.com.google.protobuf.MessageOrBuilder;

@Beta(justification="Incubating extension: https://github.com/wiremock/wiremock/issues/2383")
public class WireMockGrpc {
    private WireMockGrpc() {
    }

    public static GrpcStubMappingBuilder method(String method) {
        return new GrpcStubMappingBuilder(method);
    }

    public static StringValuePattern equalToMessage(MessageOrBuilder messageOrBuilder) {
        String json = JsonMessageUtils.toJson(messageOrBuilder);
        return WireMock.equalToJson(json, true, false);
    }

    public static GrpcResponseDefinitionBuilder json(String json) {
        return new GrpcResponseDefinitionBuilder(Status.OK).fromJson(json);
    }

    public static GrpcResponseDefinitionBuilder jsonTemplate(String json) {
        return new GrpcResponseDefinitionBuilder(Status.OK).withTemplatingEnabled(true).fromJson(json);
    }

    public static GrpcResponseDefinitionBuilder message(MessageOrBuilder messageOrBuilder) {
        String json = JsonMessageUtils.toJson(messageOrBuilder);
        return new GrpcResponseDefinitionBuilder(Status.OK).fromJson(json);
    }

    public static GrpcResponseDefinitionBuilder messageAsAny(MessageOrBuilder messageOrBuilder) {
        String initialJson = JsonMessageUtils.toJson(messageOrBuilder);
        ObjectNode jsonObject = Json.read(initialJson, ObjectNode.class);
        jsonObject.put("@type", "type.googleapis.com/" + messageOrBuilder.getDescriptorForType().getFullName());
        String finalJson = Json.write(jsonObject);
        return new GrpcResponseDefinitionBuilder(Status.OK).fromJson(finalJson);
    }

    public static enum Status {
        OK(0),
        CANCELLED(1),
        UNKNOWN(2),
        INVALID_ARGUMENT(3),
        DEADLINE_EXCEEDED(4),
        NOT_FOUND(5),
        ALREADY_EXISTS(6),
        PERMISSION_DENIED(7),
        RESOURCE_EXHAUSTED(8),
        FAILED_PRECONDITION(9),
        ABORTED(10),
        OUT_OF_RANGE(11),
        UNIMPLEMENTED(12),
        INTERNAL(13),
        UNAVAILABLE(14),
        DATA_LOSS(15),
        UNAUTHENTICATED(16);

        private final int value;

        private Status(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

