/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.grpc.internal;

import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.client.ApacheHttpClientFactory;
import com.github.tomakehurst.wiremock.http.client.HttpClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.wiremock.grpc.internal.BaseCallHandler;
import org.wiremock.grpc.internal.GrpcContext;
import org.wiremock.grpc.internal.GrpcStatusUtils;
import org.wiremock.grpc.internal.GrpcUtils;
import org.wiremock.grpc.internal.JsonMessageConverter;
import wiremock.com.google.protobuf.DynamicMessage;
import wiremock.grpc.io.grpc.CallOptions;
import wiremock.grpc.io.grpc.ManagedChannel;
import wiremock.grpc.io.grpc.ManagedChannelBuilder;
import wiremock.grpc.io.grpc.Status;
import wiremock.grpc.io.grpc.StatusRuntimeException;
import wiremock.grpc.io.grpc.stub.ClientCalls;

public class GrpcClient
implements HttpClient {
    private final HttpClient delegateClient;

    public GrpcClient(Options options, boolean trustAllCertificates, List<String> trustedHosts, boolean useSystemProperties) {
        this.delegateClient = new ApacheHttpClientFactory().buildHttpClient(options, trustAllCertificates, trustedHosts, useSystemProperties);
    }

    @Override
    public Response execute(Request request) throws IOException {
        String contentType = request.getHeader("Content-Type");
        if (!"application/grpc".equalsIgnoreCase(contentType)) {
            return this.delegateClient.execute(request);
        }
        GrpcContext context = BaseCallHandler.CONTEXT.get();
        BaseCallHandler.CONTEXT.remove();
        ManagedChannel channel = ((ManagedChannelBuilder)ManagedChannelBuilder.forAddress(request.getHost(), request.getPort()).usePlaintext()).build();
        ArrayList<HttpHeader> headers = new ArrayList<HttpHeader>();
        headers.add(new HttpHeader("Content-Type", "application/json"));
        Response.Builder grpcRespBuilder = Response.response();
        String statusName = Status.Code.OK.name();
        String statusReason = null;
        try {
            DynamicMessage responseMsg = ClientCalls.blockingUnaryCall(channel, GrpcUtils.buildMessageDescriptorInstance(context.getServiceDescriptor(), context.getMethodDescriptor()), CallOptions.DEFAULT, context.getDm());
            JsonMessageConverter converter = context.getJsonMessageConverter();
            String jsonStr = converter.toJson(responseMsg);
            headers.add(new HttpHeader("grpc-status-name", statusName));
            grpcRespBuilder.status(200).body(jsonStr);
        }
        catch (Exception e) {
            Status grpcStatus = null;
            if (e instanceof StatusRuntimeException) {
                StatusRuntimeException stsEx = (StatusRuntimeException)e;
                grpcStatus = stsEx.getStatus();
                statusName = grpcStatus.getCode().name();
                statusReason = grpcStatus.getDescription();
            } else {
                grpcStatus = Status.INTERNAL;
                statusName = Status.Code.INTERNAL.name();
                statusReason = e.getMessage();
            }
            Integer httpStatus = GrpcStatusUtils.reverseMappings.get(grpcStatus);
            if (httpStatus != null) {
                grpcRespBuilder.status(httpStatus);
            } else {
                grpcRespBuilder.status(500);
            }
            headers.add(new HttpHeader("grpc-status-name", statusName));
            headers.add(new HttpHeader("grpc-status-reason", statusReason));
        }
        return grpcRespBuilder.headers(new HttpHeaders((HttpHeader[])headers.toArray(HttpHeader[]::new))).build();
    }
}

