/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.grpc.internal;

import com.github.tomakehurst.wiremock.admin.Router;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.extension.AdminApiExtension;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.HttpServer;
import com.github.tomakehurst.wiremock.http.HttpServerFactory;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.jetty11.Jetty11HttpServer;
import com.github.tomakehurst.wiremock.store.BlobStore;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import org.wiremock.grpc.internal.GrpcFilter;
import org.wiremock.grpc.internal.GrpcResetAdminApiTask;
import wiremock.com.google.protobuf.DescriptorProtos;
import wiremock.com.google.protobuf.Descriptors;
import wiremock.jakarta.servlet.DispatcherType;
import wiremock.org.eclipse.jetty.servlet.FilterHolder;
import wiremock.org.eclipse.jetty.servlet.ServletContextHandler;

public class GrpcHttpServerFactory
implements HttpServerFactory,
AdminApiExtension {
    private final BlobStore protoDescriptorStore;
    protected GrpcFilter grpcFilter;

    public GrpcHttpServerFactory(BlobStore protoDescriptorStore) {
        this.protoDescriptorStore = protoDescriptorStore;
    }

    public void loadFileDescriptors() {
        ArrayList<Descriptors.FileDescriptor> fileDescriptors = new ArrayList<Descriptors.FileDescriptor>();
        this.protoDescriptorStore.getAllKeys().filter(key -> key.endsWith(".dsc") || key.endsWith(".desc")).map(key -> this.protoDescriptorStore.get(key).map(data -> Exceptions.uncheck(() -> DescriptorProtos.FileDescriptorSet.parseFrom(data), DescriptorProtos.FileDescriptorSet.class))).filter(Optional::isPresent).map(Optional::get).flatMap(fileDescriptorSet -> fileDescriptorSet.getFileList().stream()).forEach(fileDescriptorProto -> Exceptions.uncheck(() -> fileDescriptors.add(Descriptors.FileDescriptor.buildFrom(fileDescriptorProto, (Descriptors.FileDescriptor[])fileDescriptors.toArray(Descriptors.FileDescriptor[]::new), true))));
        this.grpcFilter.loadFileDescriptors(fileDescriptors);
    }

    @Override
    public String getName() {
        return "grpc";
    }

    @Override
    public HttpServer buildHttpServer(Options options, AdminRequestHandler adminRequestHandler, final StubRequestHandler stubRequestHandler) {
        return new Jetty11HttpServer(options, adminRequestHandler, stubRequestHandler){

            @Override
            protected void decorateMockServiceContextBeforeConfig(ServletContextHandler mockServiceContext) {
                GrpcHttpServerFactory.this.grpcFilter = new GrpcFilter(stubRequestHandler);
                GrpcHttpServerFactory.this.loadFileDescriptors();
                FilterHolder filterHolder = new FilterHolder(GrpcHttpServerFactory.this.grpcFilter);
                mockServiceContext.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
            }
        };
    }

    @Override
    public void contributeAdminApiRoutes(Router router) {
        router.add(RequestMethod.POST, "/ext/grpc/reset", new GrpcResetAdminApiTask(this));
    }
}

