/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.grpc.internal;

import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.FormParameter;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.wiremock.grpc.internal.HeaderCopyingServerInterceptor;

public class GrpcRequest
implements Request {
    private final String scheme;
    private final String host;
    private final int port;
    private final String serviceName;
    private final String methodName;
    private final String body;

    public GrpcRequest(String scheme, String host, int port, String serviceName, String methodName, String body) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.serviceName = serviceName;
        this.methodName = methodName;
        this.body = body;
    }

    @Override
    public String getUrl() {
        return "/" + this.serviceName + "/" + this.methodName;
    }

    @Override
    public String getAbsoluteUrl() {
        return this.scheme + "://" + this.host + ":" + this.port + this.getUrl();
    }

    @Override
    public RequestMethod getMethod() {
        return RequestMethod.POST;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getClientIp() {
        return null;
    }

    @Override
    public String getHeader(String key) {
        return this.header(key).firstValue();
    }

    @Override
    public HttpHeader header(String key) {
        return this.getHeaders().getHeader(key);
    }

    @Override
    public ContentTypeHeader contentTypeHeader() {
        return this.getHeaders().getContentTypeHeader();
    }

    @Override
    public HttpHeaders getHeaders() {
        return HeaderCopyingServerInterceptor.HTTP_HEADERS_CONTEXT_KEY.get();
    }

    @Override
    public boolean containsHeader(String key) {
        return this.getHeader(key) != null;
    }

    @Override
    public Set<String> getAllHeaderKeys() {
        return this.getHeaders().keys();
    }

    @Override
    public QueryParameter queryParameter(String key) {
        return QueryParameter.absent(key);
    }

    @Override
    public FormParameter formParameter(String key) {
        return FormParameter.absent(key);
    }

    @Override
    public Map<String, FormParameter> formParameters() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Cookie> getCookies() {
        return Collections.emptyMap();
    }

    @Override
    public byte[] getBody() {
        return Strings.bytesFromString(this.body);
    }

    @Override
    public String getBodyAsString() {
        return this.body;
    }

    @Override
    public String getBodyAsBase64() {
        return Encoding.encodeBase64(this.getBody());
    }

    @Override
    public boolean isMultipart() {
        return false;
    }

    @Override
    public Collection<Request.Part> getParts() {
        return Collections.emptyList();
    }

    @Override
    public Request.Part getPart(String name) {
        return null;
    }

    @Override
    public boolean isBrowserProxyRequest() {
        return false;
    }

    @Override
    public Optional<Request> getOriginalRequest() {
        return Optional.empty();
    }

    @Override
    public String getProtocol() {
        return "HTTP/2";
    }
}

