/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.grpc.internal;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.StubMappingTransformer;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.BinaryEqualToPattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;

public class GrpcStubMappingTransformer
extends StubMappingTransformer {
    @Override
    public StubMapping transform(StubMapping stubMapping, FileSource files, Parameters parameters) {
        ResponseDefinition resp = stubMapping.getResponse();
        if (resp.getHeaders() != null && resp.getHeaders().getHeader("grpc-status-name") != null) {
            RequestPattern req = stubMapping.getRequest();
            RequestPattern jsonReq = this.convertBinaryToJson(req);
            stubMapping.setRequest(jsonReq);
        }
        return stubMapping;
    }

    private RequestPattern convertBinaryToJson(RequestPattern req) {
        RequestPatternBuilder reqBuilder = RequestPatternBuilder.like(req).but();
        List<EqualToJsonPattern> convertedPatterns = req.getBodyPatterns().stream().filter(body -> body instanceof BinaryEqualToPattern).map(binaryBody -> {
            byte[] bytes = (byte[])((BinaryEqualToPattern)binaryBody).getValue();
            return new EqualToJsonPattern(new String(bytes, StandardCharsets.UTF_8), (Boolean)true, (Boolean)false);
        }).collect(Collectors.toList());
        convertedPatterns.forEach(reqBuilder::withRequestBody);
        return reqBuilder.build();
    }

    @Override
    public String getName() {
        return "grpc-stub-transformer";
    }
}

