/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.grpc.internal;

import wiremock.com.google.protobuf.Descriptors;
import wiremock.com.google.protobuf.DynamicMessage;
import wiremock.grpc.io.grpc.MethodDescriptor;
import wiremock.grpc.io.grpc.protobuf.ProtoUtils;

public class GrpcUtils {
    public static final String GRPC_STATUS_NAME = "grpc-status-name";
    public static final String GRPC_STATUS_REASON = "grpc-status-reason";

    public static MethodDescriptor<DynamicMessage, DynamicMessage> buildMessageDescriptorInstance(Descriptors.ServiceDescriptor serviceDescriptor, Descriptors.MethodDescriptor methodDescriptor) {
        return MethodDescriptor.newBuilder().setType(GrpcUtils.getMethodTypeFromDesc(methodDescriptor)).setFullMethodName(MethodDescriptor.generateFullMethodName(serviceDescriptor.getFullName(), methodDescriptor.getName())).setRequestMarshaller(ProtoUtils.marshaller(DynamicMessage.getDefaultInstance(methodDescriptor.getInputType()))).setResponseMarshaller(ProtoUtils.marshaller(DynamicMessage.getDefaultInstance(methodDescriptor.getOutputType()))).build();
    }

    public static MethodDescriptor.MethodType getMethodTypeFromDesc(Descriptors.MethodDescriptor methodDesc) {
        if (!methodDesc.isServerStreaming() && !methodDesc.isClientStreaming()) {
            return MethodDescriptor.MethodType.UNARY;
        }
        if (methodDesc.isServerStreaming() && !methodDesc.isClientStreaming()) {
            return MethodDescriptor.MethodType.SERVER_STREAMING;
        }
        if (!methodDesc.isServerStreaming()) {
            return MethodDescriptor.MethodType.CLIENT_STREAMING;
        }
        return MethodDescriptor.MethodType.BIDI_STREAMING;
    }
}

