/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.grpc.internal;

import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import wiremock.grpc.io.grpc.Context;
import wiremock.grpc.io.grpc.Contexts;
import wiremock.grpc.io.grpc.Metadata;
import wiremock.grpc.io.grpc.ServerCall;
import wiremock.grpc.io.grpc.ServerCallHandler;
import wiremock.grpc.io.grpc.ServerInterceptor;

public class HeaderCopyingServerInterceptor
implements ServerInterceptor {
    public static final Context.Key<HttpHeaders> HTTP_HEADERS_CONTEXT_KEY = Context.key("HTTP_HEADERS_CONTEXT_KEY");

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        HttpHeaders httpHeaders = HeaderCopyingServerInterceptor.buildHttpHeaders(headers);
        Context newContext = Context.current().withValue(HTTP_HEADERS_CONTEXT_KEY, httpHeaders);
        return Contexts.interceptCall(newContext, call, headers, next);
    }

    private static HttpHeaders buildHttpHeaders(Metadata metadata) {
        List<HttpHeader> httpHeaderList = metadata.keys().stream().map(key -> {
            if (key.endsWith("-bin")) {
                return new HttpHeader((String)key, Arrays.toString(metadata.get(Metadata.Key.of(key, Metadata.BINARY_BYTE_MARSHALLER))));
            }
            return new HttpHeader((String)key, metadata.get(Metadata.Key.of(key, Metadata.ASCII_STRING_MARSHALLER)));
        }).collect(Collectors.toList());
        return new HttpHeaders(httpHeaderList);
    }
}

