/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.grpc.internal;

import com.github.tomakehurst.wiremock.common.Pair;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import org.wiremock.grpc.dsl.WireMockGrpc;
import org.wiremock.grpc.internal.BaseCallHandler;
import org.wiremock.grpc.internal.Delays;
import org.wiremock.grpc.internal.GrpcContext;
import org.wiremock.grpc.internal.GrpcFilter;
import org.wiremock.grpc.internal.GrpcRequest;
import org.wiremock.grpc.internal.GrpcStatusUtils;
import org.wiremock.grpc.internal.JsonMessageConverter;
import wiremock.com.google.protobuf.Descriptors;
import wiremock.com.google.protobuf.DynamicMessage;
import wiremock.grpc.io.grpc.Status;
import wiremock.grpc.io.grpc.stub.ServerCalls;
import wiremock.grpc.io.grpc.stub.StreamObserver;

public class UnaryServerCallHandler
extends BaseCallHandler
implements ServerCalls.UnaryMethod<DynamicMessage, DynamicMessage> {
    public UnaryServerCallHandler(StubRequestHandler stubRequestHandler, Descriptors.ServiceDescriptor serviceDescriptor, Descriptors.MethodDescriptor methodDescriptor, JsonMessageConverter jsonMessageConverter) {
        super(stubRequestHandler, serviceDescriptor, methodDescriptor, jsonMessageConverter);
    }

    @Override
    public void invoke(DynamicMessage request, StreamObserver<DynamicMessage> responseObserver) {
        GrpcFilter.ServerAddress serverAddress = GrpcFilter.ServerAddress.get();
        CONTEXT.set(new GrpcContext(this.serviceDescriptor, this.methodDescriptor, this.jsonMessageConverter, request));
        GrpcRequest wireMockRequest = new GrpcRequest(serverAddress.scheme, serverAddress.hostname, serverAddress.port, this.serviceDescriptor.getFullName(), this.methodDescriptor.getName(), this.jsonMessageConverter.toJson(request));
        this.stubRequestHandler.handle(wireMockRequest, (req, resp, attributes) -> {
            HttpHeader statusHeader = resp.getHeaders().getHeader("grpc-status-name");
            Delays.delayIfRequired(resp);
            if (!statusHeader.isPresent() && GrpcStatusUtils.errorHttpToGrpcStatusMappings.containsKey(resp.getStatus())) {
                Pair<Status, String> statusMapping = GrpcStatusUtils.errorHttpToGrpcStatusMappings.get(resp.getStatus());
                responseObserver.onError(((Status)statusMapping.a).withDescription((String)statusMapping.b).asRuntimeException());
                return;
            }
            if (statusHeader.isPresent() && !statusHeader.firstValue().equals(Status.Code.OK.name())) {
                HttpHeader statusReasonHeader = resp.getHeaders().getHeader("grpc-status-reason");
                String reason = statusReasonHeader.isPresent() ? statusReasonHeader.firstValue() : "";
                WireMockGrpc.Status status = WireMockGrpc.Status.valueOf(statusHeader.firstValue());
                responseObserver.onError(Status.fromCodeValue(status.getValue()).withDescription(reason).asRuntimeException());
                return;
            }
            DynamicMessage.Builder messageBuilder = DynamicMessage.newBuilder(this.methodDescriptor.getOutputType());
            DynamicMessage response = (DynamicMessage)this.jsonMessageConverter.toMessage(resp.getBodyAsString(), messageBuilder);
            responseObserver.onNext(response);
            responseObserver.onCompleted();
        }, ServeEvent.of(wireMockRequest));
    }
}

