/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.ObjectMapper;
import wiremock.com.networknt.schema.DefaultJsonMetaSchemaFactory;
import wiremock.com.networknt.schema.InputFormat;
import wiremock.com.networknt.schema.JsonMetaSchema;
import wiremock.com.networknt.schema.JsonMetaSchemaFactory;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonSchemaException;
import wiremock.com.networknt.schema.JsonSchemaVersion;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.SchemaValidatorsConfig;
import wiremock.com.networknt.schema.SpecVersion;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.Version201909;
import wiremock.com.networknt.schema.Version202012;
import wiremock.com.networknt.schema.Version4;
import wiremock.com.networknt.schema.Version6;
import wiremock.com.networknt.schema.Version7;
import wiremock.com.networknt.schema.resource.DefaultSchemaLoader;
import wiremock.com.networknt.schema.resource.SchemaLoader;
import wiremock.com.networknt.schema.resource.SchemaLoaders;
import wiremock.com.networknt.schema.resource.SchemaMapper;
import wiremock.com.networknt.schema.resource.SchemaMappers;
import wiremock.com.networknt.schema.serialization.JsonMapperFactory;
import wiremock.com.networknt.schema.serialization.JsonNodeReader;
import wiremock.com.networknt.schema.serialization.YamlMapperFactory;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class JsonSchemaFactory {
    private static final Logger logger = LoggerFactory.getLogger(JsonSchemaFactory.class);
    private final ObjectMapper jsonMapper;
    private final ObjectMapper yamlMapper;
    private final JsonNodeReader jsonNodeReader;
    private final String defaultMetaSchemaIri;
    private final SchemaLoaders.Builder schemaLoadersBuilder;
    private final SchemaMappers.Builder schemaMappersBuilder;
    private final SchemaLoader schemaLoader;
    private final ConcurrentMap<String, JsonMetaSchema> metaSchemas;
    private final ConcurrentMap<SchemaLocation, JsonSchema> schemaCache = new ConcurrentHashMap<SchemaLocation, JsonSchema>();
    private final boolean enableSchemaCache;
    private final JsonMetaSchemaFactory metaSchemaFactory;
    private static final List<SchemaLoader> DEFAULT_SCHEMA_LOADERS = SchemaLoaders.builder().build();
    private static final List<SchemaMapper> DEFAULT_SCHEMA_MAPPERS = SchemaMappers.builder().build();

    private JsonSchemaFactory(ObjectMapper jsonMapper, ObjectMapper yamlMapper, JsonNodeReader jsonNodeReader, String defaultMetaSchemaIri, SchemaLoaders.Builder schemaLoadersBuilder, SchemaMappers.Builder schemaMappersBuilder, ConcurrentMap<String, JsonMetaSchema> metaSchemas, boolean enableSchemaCache, JsonMetaSchemaFactory metaSchemaFactory) {
        this.metaSchemas = metaSchemas;
        if (defaultMetaSchemaIri == null || defaultMetaSchemaIri.trim().isEmpty()) {
            throw new IllegalArgumentException("defaultMetaSchemaIri must not be null or empty");
        }
        if (metaSchemas == null || metaSchemas.isEmpty()) {
            throw new IllegalArgumentException("Json Meta Schemas must not be null or empty");
        }
        if (this.metaSchemas.get(JsonSchemaFactory.normalizeMetaSchemaUri(defaultMetaSchemaIri)) == null) {
            throw new IllegalArgumentException("Meta Schema for default Meta Schema URI must be provided");
        }
        this.jsonMapper = jsonMapper;
        this.yamlMapper = yamlMapper;
        this.jsonNodeReader = jsonNodeReader;
        this.defaultMetaSchemaIri = defaultMetaSchemaIri;
        this.schemaLoadersBuilder = schemaLoadersBuilder;
        this.schemaMappersBuilder = schemaMappersBuilder;
        this.schemaLoader = new DefaultSchemaLoader(schemaLoadersBuilder != null ? schemaLoadersBuilder.build() : DEFAULT_SCHEMA_LOADERS, schemaMappersBuilder != null ? schemaMappersBuilder.build() : DEFAULT_SCHEMA_MAPPERS);
        this.enableSchemaCache = enableSchemaCache;
        this.metaSchemaFactory = metaSchemaFactory;
    }

    public SchemaLoader getSchemaLoader() {
        return this.schemaLoader;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static JsonSchemaFactory getInstance(SpecVersion.VersionFlag versionFlag) {
        return JsonSchemaFactory.getInstance(versionFlag, null);
    }

    public static JsonSchemaFactory getInstance(SpecVersion.VersionFlag versionFlag, Consumer<Builder> customizer) {
        JsonSchemaVersion jsonSchemaVersion = JsonSchemaFactory.checkVersion(versionFlag);
        JsonMetaSchema metaSchema = jsonSchemaVersion.getInstance();
        Builder builder = JsonSchemaFactory.builder().defaultMetaSchemaIri(metaSchema.getIri()).metaSchema(metaSchema);
        if (customizer != null) {
            customizer.accept(builder);
        }
        return builder.build();
    }

    public static JsonSchemaVersion checkVersion(SpecVersion.VersionFlag versionFlag) {
        if (null == versionFlag) {
            return null;
        }
        switch (versionFlag) {
            case V202012: {
                return new Version202012();
            }
            case V201909: {
                return new Version201909();
            }
            case V7: {
                return new Version7();
            }
            case V6: {
                return new Version6();
            }
            case V4: {
                return new Version4();
            }
        }
        throw new IllegalArgumentException("Unsupported value" + (Object)((Object)versionFlag));
    }

    public static Builder builder(JsonSchemaFactory blueprint) {
        Builder builder = JsonSchemaFactory.builder().metaSchemas(blueprint.metaSchemas.values()).defaultMetaSchemaIri(blueprint.defaultMetaSchemaIri).jsonMapper(blueprint.jsonMapper).yamlMapper(blueprint.yamlMapper).jsonNodeReader(blueprint.jsonNodeReader);
        if (blueprint.schemaLoadersBuilder != null) {
            builder.schemaLoadersBuilder = SchemaLoaders.builder().with(blueprint.schemaLoadersBuilder);
        }
        if (blueprint.schemaMappersBuilder != null) {
            builder.schemaMappersBuilder = SchemaMappers.builder().with(blueprint.schemaMappersBuilder);
        }
        return builder;
    }

    protected JsonSchema newJsonSchema(SchemaLocation schemaUri, JsonNode schemaNode, SchemaValidatorsConfig config) {
        ValidationContext validationContext = this.createValidationContext(schemaNode, config);
        JsonSchema jsonSchema = this.doCreate(validationContext, this.getSchemaLocation(schemaUri), new JsonNodePath(validationContext.getConfig().getPathType()), schemaNode, null, false);
        this.preload(jsonSchema, config);
        return jsonSchema;
    }

    private void preload(JsonSchema jsonSchema, SchemaValidatorsConfig config) {
        if (config.isPreloadJsonSchema()) {
            try {
                jsonSchema.initializeValidators();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JsonSchema create(ValidationContext validationContext, SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema) {
        return this.doCreate(validationContext, schemaLocation, evaluationPath, schemaNode, parentSchema, false);
    }

    private JsonSchema doCreate(ValidationContext validationContext, SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, boolean suppressSubSchemaRetrieval) {
        return JsonSchema.from(this.withMetaSchema(validationContext, schemaNode), schemaLocation, evaluationPath, schemaNode, parentSchema, suppressSubSchemaRetrieval);
    }

    private ValidationContext withMetaSchema(ValidationContext validationContext, JsonNode schemaNode) {
        JsonMetaSchema metaSchema = this.getMetaSchema(schemaNode, validationContext.getConfig());
        if (metaSchema != null && !metaSchema.getIri().equals(validationContext.getMetaSchema().getIri())) {
            SchemaValidatorsConfig config = validationContext.getConfig();
            if (metaSchema.getKeywords().containsKey("discriminator") && !config.isDiscriminatorKeywordEnabled()) {
                config = SchemaValidatorsConfig.builder(config).discriminatorKeywordEnabled(true).nullableKeywordEnabled(true).build();
            }
            return new ValidationContext(metaSchema, validationContext.getJsonSchemaFactory(), config, validationContext.getSchemaReferences(), validationContext.getSchemaResources(), validationContext.getDynamicAnchors());
        }
        return validationContext;
    }

    protected SchemaLocation getSchemaLocation(SchemaLocation schemaLocation) {
        return schemaLocation != null ? schemaLocation : SchemaLocation.DOCUMENT;
    }

    protected ValidationContext createValidationContext(JsonNode schemaNode, SchemaValidatorsConfig config) {
        JsonMetaSchema jsonMetaSchema = this.getMetaSchemaOrDefault(schemaNode, config);
        SchemaValidatorsConfig configResult = config;
        if (jsonMetaSchema.getKeywords().containsKey("discriminator") && !config.isDiscriminatorKeywordEnabled()) {
            configResult = SchemaValidatorsConfig.builder(config).discriminatorKeywordEnabled(true).nullableKeywordEnabled(true).build();
        }
        return new ValidationContext(jsonMetaSchema, this, configResult);
    }

    private JsonMetaSchema getMetaSchema(JsonNode schemaNode, SchemaValidatorsConfig config) {
        JsonNode iriNode = schemaNode.get("$schema");
        if (iriNode != null && iriNode.isTextual()) {
            JsonMetaSchema result = this.metaSchemas.computeIfAbsent(JsonSchemaFactory.normalizeMetaSchemaUri(iriNode.textValue()), id -> this.loadMetaSchema((String)id, config));
            return result;
        }
        return null;
    }

    private JsonMetaSchema getMetaSchemaOrDefault(JsonNode schemaNode, SchemaValidatorsConfig config) {
        JsonNode iriNode = schemaNode.get("$schema");
        if (iriNode != null && !iriNode.isNull() && !iriNode.isTextual()) {
            throw new JsonSchemaException("Unknown MetaSchema: " + iriNode);
        }
        String iri = iriNode == null || iriNode.isNull() ? this.defaultMetaSchemaIri : iriNode.textValue();
        return this.getMetaSchema(iri, config);
    }

    public JsonMetaSchema getMetaSchema(String iri, SchemaValidatorsConfig config) {
        String key = JsonSchemaFactory.normalizeMetaSchemaUri(iri);
        JsonMetaSchema result = this.metaSchemas.computeIfAbsent(key, id -> this.loadMetaSchema((String)id, config));
        return result;
    }

    protected JsonMetaSchema loadMetaSchema(String iri, SchemaValidatorsConfig config) {
        return this.metaSchemaFactory != null ? this.metaSchemaFactory.getMetaSchema(iri, this, config) : DefaultJsonMetaSchemaFactory.getInstance().getMetaSchema(iri, this, config);
    }

    JsonNode readTree(String content, InputFormat inputFormat) throws IOException {
        if (this.jsonNodeReader == null) {
            return this.getObjectMapper(inputFormat).readTree(content);
        }
        return this.jsonNodeReader.readTree(content, inputFormat);
    }

    JsonNode readTree(InputStream content, InputFormat inputFormat) throws IOException {
        if (this.jsonNodeReader == null) {
            return this.getObjectMapper(inputFormat).readTree(content);
        }
        return this.jsonNodeReader.readTree(content, inputFormat);
    }

    ObjectMapper getObjectMapper(InputFormat inputFormat) {
        if (InputFormat.JSON.equals((Object)inputFormat)) {
            return this.getJsonMapper();
        }
        if (InputFormat.YAML.equals((Object)inputFormat)) {
            return this.getYamlMapper();
        }
        throw new IllegalArgumentException("Unsupported input format " + (Object)((Object)inputFormat));
    }

    public JsonSchema getSchema(String schema, SchemaValidatorsConfig config) {
        return this.getSchema(schema, InputFormat.JSON, config);
    }

    public JsonSchema getSchema(String schema, InputFormat inputFormat, SchemaValidatorsConfig config) {
        try {
            JsonNode schemaNode = this.readTree(schema, inputFormat);
            return this.newJsonSchema(null, schemaNode, config);
        }
        catch (IOException ioe) {
            logger.error("Failed to load json schema!", (Throwable)ioe);
            throw new JsonSchemaException(ioe);
        }
    }

    public JsonSchema getSchema(String schema) {
        return this.getSchema(schema, this.createSchemaValidatorsConfig());
    }

    public JsonSchema getSchema(String schema, InputFormat inputFormat) {
        return this.getSchema(schema, inputFormat, this.createSchemaValidatorsConfig());
    }

    public JsonSchema getSchema(InputStream schemaStream, SchemaValidatorsConfig config) {
        return this.getSchema(schemaStream, InputFormat.JSON, config);
    }

    public JsonSchema getSchema(InputStream schemaStream, InputFormat inputFormat, SchemaValidatorsConfig config) {
        try {
            JsonNode schemaNode = this.readTree(schemaStream, inputFormat);
            return this.newJsonSchema(null, schemaNode, config);
        }
        catch (IOException ioe) {
            logger.error("Failed to load json schema!", (Throwable)ioe);
            throw new JsonSchemaException(ioe);
        }
    }

    public JsonSchema getSchema(InputStream schemaStream) {
        return this.getSchema(schemaStream, this.createSchemaValidatorsConfig());
    }

    public JsonSchema getSchema(SchemaLocation schemaUri, SchemaValidatorsConfig config) {
        JsonSchema schema = this.loadSchema(schemaUri, config);
        this.preload(schema, config);
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonSchema loadSchema(SchemaLocation schemaUri, SchemaValidatorsConfig config) {
        if (this.enableSchemaCache) {
            JsonSchema cachedUriSchema = (JsonSchema)this.schemaCache.get(schemaUri);
            if (cachedUriSchema == null) {
                JsonSchemaFactory jsonSchemaFactory = this;
                synchronized (jsonSchemaFactory) {
                    cachedUriSchema = (JsonSchema)this.schemaCache.get(schemaUri);
                    if (cachedUriSchema == null && (cachedUriSchema = this.getMappedSchema(schemaUri, config)) != null) {
                        this.schemaCache.put(schemaUri, cachedUriSchema);
                    }
                }
            }
            return cachedUriSchema.withConfig(config);
        }
        return this.getMappedSchema(schemaUri, config);
    }

    ObjectMapper getYamlMapper() {
        return this.yamlMapper != null ? this.yamlMapper : YamlMapperFactory.getInstance();
    }

    ObjectMapper getJsonMapper() {
        return this.jsonMapper != null ? this.jsonMapper : JsonMapperFactory.getInstance();
    }

    protected SchemaValidatorsConfig createSchemaValidatorsConfig() {
        return new SchemaValidatorsConfig();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JsonSchema getMappedSchema(SchemaLocation schemaUri, SchemaValidatorsConfig config) {
        try (InputStream inputStream = this.schemaLoader.getSchema(schemaUri.getAbsoluteIri()).getInputStream();){
            JsonNode schemaNode222;
            if (inputStream == null) {
                throw new IOException("Cannot load schema at " + schemaUri);
            }
            if (this.isYaml(schemaUri)) {
                JsonNode schemaNode = this.readTree(inputStream, InputFormat.YAML);
            } else {
                schemaNode222 = this.readTree(inputStream, InputFormat.JSON);
            }
            JsonMetaSchema jsonMetaSchema = this.getMetaSchemaOrDefault(schemaNode222, config);
            JsonNodePath evaluationPath = new JsonNodePath(config.getPathType());
            if (schemaUri.getFragment() == null || schemaUri.getFragment().getNameCount() == 0) {
                ValidationContext validationContext = new ValidationContext(jsonMetaSchema, this, config);
                JsonSchema jsonSchema = this.doCreate(validationContext, schemaUri, evaluationPath, schemaNode222, null, true);
                return jsonSchema;
            }
            ValidationContext validationContext = this.createValidationContext(schemaNode222, config);
            SchemaLocation documentLocation = new SchemaLocation(schemaUri.getAbsoluteIri());
            JsonSchema document = this.doCreate(validationContext, documentLocation, evaluationPath, schemaNode222, null, false);
            JsonSchema jsonSchema = document.getRefSchema(schemaUri.getFragment());
            return jsonSchema;
        }
        catch (IOException e) {
            logger.error("Failed to load json schema from {}", (Object)schemaUri.getAbsoluteIri(), (Object)e);
            JsonSchemaException exception = new JsonSchemaException("Failed to load json schema from " + schemaUri.getAbsoluteIri());
            exception.initCause(e);
            throw exception;
        }
    }

    public JsonSchema getSchema(URI schemaUri) {
        return this.getSchema(SchemaLocation.of(schemaUri.toString()), this.createSchemaValidatorsConfig());
    }

    public JsonSchema getSchema(URI schemaUri, JsonNode jsonNode, SchemaValidatorsConfig config) {
        return this.newJsonSchema(SchemaLocation.of(schemaUri.toString()), jsonNode, config);
    }

    public JsonSchema getSchema(URI schemaUri, JsonNode jsonNode) {
        return this.newJsonSchema(SchemaLocation.of(schemaUri.toString()), jsonNode, this.createSchemaValidatorsConfig());
    }

    public JsonSchema getSchema(SchemaLocation schemaUri) {
        return this.getSchema(schemaUri, this.createSchemaValidatorsConfig());
    }

    public JsonSchema getSchema(SchemaLocation schemaUri, JsonNode jsonNode, SchemaValidatorsConfig config) {
        return this.newJsonSchema(schemaUri, jsonNode, config);
    }

    public JsonSchema getSchema(SchemaLocation schemaUri, JsonNode jsonNode) {
        return this.newJsonSchema(schemaUri, jsonNode, this.createSchemaValidatorsConfig());
    }

    public JsonSchema getSchema(JsonNode jsonNode, SchemaValidatorsConfig config) {
        return this.newJsonSchema(null, jsonNode, config);
    }

    public JsonSchema getSchema(JsonNode jsonNode) {
        return this.newJsonSchema(null, jsonNode, this.createSchemaValidatorsConfig());
    }

    private boolean isYaml(SchemaLocation schemaUri) {
        String schemeSpecificPart = schemaUri.getAbsoluteIri().toString();
        int idx = schemeSpecificPart.lastIndexOf(46);
        if (idx == -1) {
            return false;
        }
        String extension = schemeSpecificPart.substring(idx);
        return ".yml".equals(extension) || ".yaml".equals(extension);
    }

    protected static String normalizeMetaSchemaUri(String id) {
        boolean found = false;
        for (SpecVersion.VersionFlag flag : SpecVersion.VersionFlag.values()) {
            if (!flag.getId().equals(id)) continue;
            found = true;
            break;
        }
        if (!found && id.contains("://json-schema.org/draft")) {
            if (id.contains("/draft-07/")) {
                id = "http://json-schema.org/draft-07/schema#";
            } else if (id.contains("/draft/2019-09/")) {
                id = "https://json-schema.org/draft/2019-09/schema";
            } else if (id.contains("/draft/2020-12/")) {
                id = "https://json-schema.org/draft/2020-12/schema";
            } else if (id.contains("/draft-04/")) {
                id = "http://json-schema.org/draft-04/schema#";
            } else if (id.contains("/draft-06/")) {
                id = "http://json-schema.org/draft-06/schema#";
            }
        }
        return id;
    }

    public static class Builder {
        private ObjectMapper jsonMapper = null;
        private ObjectMapper yamlMapper = null;
        private JsonNodeReader jsonNodeReader = null;
        private String defaultMetaSchemaIri;
        private final ConcurrentMap<String, JsonMetaSchema> metaSchemas = new ConcurrentHashMap<String, JsonMetaSchema>();
        private SchemaLoaders.Builder schemaLoadersBuilder = null;
        private SchemaMappers.Builder schemaMappersBuilder = null;
        private boolean enableSchemaCache = true;
        private JsonMetaSchemaFactory metaSchemaFactory = null;

        public Builder jsonNodeReader(JsonNodeReader jsonNodeReader) {
            this.jsonNodeReader = jsonNodeReader;
            return this;
        }

        @Deprecated
        public Builder jsonMapper(ObjectMapper jsonMapper) {
            this.jsonMapper = jsonMapper;
            return this;
        }

        @Deprecated
        public Builder yamlMapper(ObjectMapper yamlMapper) {
            this.yamlMapper = yamlMapper;
            return this;
        }

        public Builder defaultMetaSchemaIri(String defaultMetaSchemaIri) {
            this.defaultMetaSchemaIri = defaultMetaSchemaIri;
            return this;
        }

        public Builder metaSchemaFactory(JsonMetaSchemaFactory jsonMetaSchemaFactory) {
            this.metaSchemaFactory = jsonMetaSchemaFactory;
            return this;
        }

        public Builder metaSchema(JsonMetaSchema jsonMetaSchema) {
            this.metaSchemas.put(JsonSchemaFactory.normalizeMetaSchemaUri(jsonMetaSchema.getIri()), jsonMetaSchema);
            return this;
        }

        public Builder metaSchemas(Collection<? extends JsonMetaSchema> jsonMetaSchemas) {
            for (JsonMetaSchema jsonMetaSchema : jsonMetaSchemas) {
                this.metaSchema(jsonMetaSchema);
            }
            return this;
        }

        public Builder metaSchemas(Consumer<Map<String, JsonMetaSchema>> customizer) {
            customizer.accept(this.metaSchemas);
            return this;
        }

        public Builder enableSchemaCache(boolean enableSchemaCache) {
            this.enableSchemaCache = enableSchemaCache;
            return this;
        }

        public Builder schemaLoaders(Consumer<SchemaLoaders.Builder> schemaLoadersBuilderCustomizer) {
            if (this.schemaLoadersBuilder == null) {
                this.schemaLoadersBuilder = SchemaLoaders.builder();
            }
            schemaLoadersBuilderCustomizer.accept(this.schemaLoadersBuilder);
            return this;
        }

        public Builder schemaMappers(Consumer<SchemaMappers.Builder> schemaMappersBuilderCustomizer) {
            if (this.schemaMappersBuilder == null) {
                this.schemaMappersBuilder = SchemaMappers.builder();
            }
            schemaMappersBuilderCustomizer.accept(this.schemaMappersBuilder);
            return this;
        }

        @Deprecated
        public Builder addMetaSchema(JsonMetaSchema jsonMetaSchema) {
            return this.metaSchema(jsonMetaSchema);
        }

        @Deprecated
        public Builder addMetaSchemas(Collection<? extends JsonMetaSchema> jsonMetaSchemas) {
            return this.metaSchemas(jsonMetaSchemas);
        }

        public JsonSchemaFactory build() {
            return new JsonSchemaFactory(this.jsonMapper, this.yamlMapper, this.jsonNodeReader, this.defaultMetaSchemaIri, this.schemaLoadersBuilder, this.schemaMappersBuilder, this.metaSchemas, this.enableSchemaCache, this.metaSchemaFactory);
        }
    }
}

