/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema.format;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.Format;
import wiremock.com.networknt.schema.ValidationContext;

public class DurationFormat
implements Format {
    private static final String DURATION = "duration";
    private static final Pattern STRICT = Pattern.compile("^(?:P\\d+W)|(?:P(?:\\d+Y)?(?:\\d+M)?(?:\\d+D)?(?:T(?:\\d+H)?(?:\\d+M)?(?:\\d+S)?)?)$", 2);
    private static final Pattern LAX = Pattern.compile("^(?:[-+]?)P(?:[-+]?[0-9]+Y)?(?:[-+]?[0-9]+M)?(?:[-+]?[0-9]+W)?(?:[-+]?[0-9]+D)?(?:T(?:[-+]?[0-9]+H)?(?:[-+]?[0-9]+M)?(?:[-+]?[0-9]+(?:[.,][0-9]{0,9})?S)?)?$", 2);

    @Override
    public boolean matches(ExecutionContext executionContext, ValidationContext validationContext, String duration) {
        if (null == duration) {
            return true;
        }
        if (duration.endsWith("P") || duration.endsWith("T")) {
            return false;
        }
        Pattern pattern = this.isStrictValidation(validationContext) ? STRICT : LAX;
        Matcher matcher = pattern.matcher(duration);
        return matcher.matches();
    }

    protected boolean isStrictValidation(ValidationContext validationContext) {
        return validationContext.getConfig().isStrict(DURATION);
    }

    @Override
    public String getName() {
        return DURATION;
    }

    @Override
    public String getMessageKey() {
        return "format.duration";
    }
}

